const Reactive = function(cfg){
    this.state = cfg || {};
    this.subs = {};
};

Reactive.prototype = {
    fire: function(key, val, lastVal){
        if(key in this.subs){
            const subs = this.subs[key];
            for(let i = 0, _i = subs.length; i < _i; i++){
                subs[i](val, lastVal);
            }
        }
    },
    on: function(key, fn){
        this.subs[key] || (this.subs[key] = []).push(fn);
        if(key in this.state)
            fn(this.state[key]);
    },
    un: function(key, fn){

    },
    set: function(obj){
        for(let key in obj)
            this.setKey(key, obj[key]);
    },
    setKey: function(key, val){
        const lastVal = this.state[key];
        if(lastVal === val)
            return null;
        this.state[key] = val;
        this.fire(key, val, lastVal);
        return true;
    }
};

const Button = function(cfg){
    Reactive.call(this, this.def);
    this.children = [];
    this.set(cfg);

};
Button.prototype = new Reactive();
Object.assign(Button.prototype, {
    def: {
        type: 'Button',
        disabled: false
    },
    render: function(where){
        const button = document.createElement('button');
        this.on('value', (val)=>button.innerText = val);
        where.appendChild(button);
    },
    addChild: function (child) {
        this.children.push(child);
    }
});

/*const btn = new Button({value: '123'});
btn.render(document.body);

let count = 0;
setInterval(()=>{
    btn.set({value: 'btn '+(count++)})
},100);*/

export {Button};