import {Component, h, PropSettersInterface, EventHandler} from '../Rjsx';
interface ButtonProps {
    onClick: EventHandler<MouseEvent>
}
class Button extends Component<ButtonProps> {
    button: Component = null;
    def = {
        type: 'Button',
        disabled: false
    };
    setters: PropSettersInterface<Button> = {
        value: (_,val:string)=>_.button.el.innerText = val,
        disabled: (_,val:boolean)=>_.button.set({disabled: val})
    };
    render(){
        //@ts-ignore
        this.button = <button/>;
        return this.button;
    }
}

export {Button};