import {assert} from 'chai';
//import {describe, it} from 'mocha';
import dom from 'simplest-dom';
global.document = new dom();
let animationFnList = [];
global.requestAnimationFrame = function(fn) {
    animationFnList.push(fn);
};
const animate = function() {
    const list = animationFnList;
    animationFnList = [];
    list.forEach(function(fn) {
        fn();
    });
};


import {h, R, Component} from '../src/F';

describe('creating element', function() {
    it('should create element', function() {
        let div = <div/>;
        assert.equal(div.el.nodeName, 'div', 'create correct element');
    });
    it('should create nested elements', function() {
        let div = <div><b/></div>;
        assert.equal(div.el.nodeName, 'div', 'create correct element');
        assert.equal(div.el.childNodes[0].nodeName, 'b', 'create correct child element');
    });
    it('should create and compose element with cls and content', function() {
        let div = <div class="cls1">abc</div>;
        assert.equal(div.el.outerHTML, '<div class="cls1">abc</div>', 'create correct element');
    });
});

describe('reactive', function() {
    it('should update dependency', function() {
        let div1 = <div n="1" a={3} b={4}/>
        let div = <div
            n={R(div1.sub('n'))}
            m={R(div1.sub('a'),div1.sub('b'), (a,b)=>a*b)}
        />;
        assert.equal(div1.state.n, '1', 'setted correctly');
        assert.equal(div.state.n, void 0, 'before property update');

        assert.equal(div.state.m, void 0, 'before property update');

        animate();
        assert.equal(div.state.n, '1', 'setted correctly through dependency');
        assert.equal(div.state.m, 3*4, 'setted correctly through dependency of two props');
        const newVal = 22;
        div1.set({n: newVal, a: div1.get('a')+1});
        assert.equal(div1.get('a'), 4, 'setted correctly through dependency');
        assert.equal(div.state.n, '1', 'setted correctly through dependency');
        assert.equal(div.state.m, 3*4, 'setted correctly through dependency of two props');

        animate();
        assert.equal(div.state.n, newVal, 'setted correctly through dependency');
        assert.equal(div.state.m, 4*4, 'setted correctly through dependency of two props');
    })
});

describe('components', function() {
    let MyCmp;
    let nest1, nest2, nest3;
    it('should extend Component', function(){
        MyCmp = Component.extend( 'MyCmp', {
            def: {
                prop1: true,
                prop2: false,
                nest: nest1 = {
                    num: 1,
                    str: 'str'
                },
                prop3: void 0,
                prop4: null,
                nest2: nest2 = {
                    subNest2: nest3 = {
                        a: 42,
                        b: 33
                    }
                }
            },
            setters: {
                nest2: ( _, val, lastVal, theKey, state ) => {
                    if(!state.nest2){
                        state.nest2 = {};
                    }
                    Object.assign(state.nest2, val);
                    return false;
                    //Object.assign( _.state.nest, val )

                },
                style: ( _, val ) => {

                }
            },
            render: () => {
                return <div/>;
            }

        } );

        var cm = <MyCmp/>;
        assert.equal( cm.get( 'prop1' ), true, 'default bool prop' );
        assert.equal( cm.get( 'prop2' ), false, 'default bool prop' );
        assert.equal( cm.get( 'nest' ), nest1, 'nested prop' );
        assert.equal( cm.get( 'nest.num' ), nest1.num, 'nested number prop' );
        assert.equal( cm.get( 'nest.str' ), nest1.str, 'nested string prop' );
        assert.equal( cm.get( 'prop3' ), void 0, 'undefined prop' );
        assert.equal( cm.get( 'prop4' ), null, 'null prop' );
        assert.deepEqual( cm.get( 'nest2' ), nest2, 'nested2 prop' );
        assert.deepEqual( cm.get( 'nest2.subNest2' ), nest3, 'nested2 nested prop' );
        assert.equal( cm.get( 'nest2.subNest2.a' ), nest3.a, 'nested2 nested number prop' );
        assert.equal( cm.get( 'nest2.subNest2.b' ), nest3.b, 'nested2 nested number prop' );
    });
    it('should correctly overwrite props', function() {
        let newNest1 = {num:3};
        let cmp = <MyCmp prop2={false} nest={newNest1} nest2={
            {x: 666}
        }/>;
        assert.equal(cmp.get('prop1'), true, 'default bool prop');
        assert.equal(cmp.get('prop2'), false, 'default bool prop');
        assert.deepEqual(cmp.get('nest'), newNest1, 'nested prop');

        assert.equal(cmp.get('prop3'), void 0, 'undefined prop');
        assert.equal(cmp.get('prop4'), null, 'null prop');
        assert.deepEqual(cmp.get('nest2'), { subNest2: { a: 42, b: 33 }, x: 666 }, 'nested2 prop');
    });

});