import {PropertySetterInterface, PropSettersInterface} from "./Rjsx";

const byPass = a => a;
const emptyFn = ()=>void 0;

export const Reactivity = function(args) {
    this.args = args;
};

Reactivity.prototype = {
    args: [],
    scope: null,
    key: null,
    fn: null,
    emit: function() {
        TaskManager.add(()=>{
            this.scope._setKey(this.key, 0, this.fn.apply(this.scope, this.args), this.scope.state, this.scope.setters);
        });
    }
};

let jobSwap = [];
const Task = function(fn, scope) {
    this.fn = fn;
    this.scope = scope;
};
export const TaskManager = {
    jobs: [],
    active: false,
    add: function(taskFn, scope) {
        TaskManager.jobs.push(new Task(taskFn, scope));
        if(!TaskManager.active) {
            TaskManager.active = true;
            requestAnimationFrame(TaskManager.work);
        }
    },
    work: function() {
        const jobs = TaskManager.jobs;
        TaskManager.jobs = jobSwap;
        jobSwap.length = 0;
        jobSwap = jobs;
        TaskManager.active = false;

        let i, _i, job;
        for (i = 0, _i = jobs.length; i < _i; i++) {
            job = jobs[i];
            job.fn.call(job.scope);
        }
    }
};

export const R = function() {
    const args = [];

    const reactivity = new Reactivity(args);
    for(let i = 0, _i = arguments.length === 1 ? arguments.length : arguments.length - 1; i < _i; i++){
        const obj = arguments[i];
        if(typeof obj === 'function'){
            TaskManager.add(()=>{
                const objResolved = obj();
                objResolved.trigger = (val) => {
                    args[i] = val;
                    reactivity.emit();
                };
                args[i] = objResolved.value;
            })
        } else {

            obj.trigger = (val) => {
                args[i] = val;
                reactivity.emit();
            };
            args[i] = obj.value;
        }
    }

    if(arguments.length === 1){
        reactivity.fn = byPass;
    }else{
        reactivity.fn = arguments[arguments.length-1];
    }

    return reactivity;
};

export const Reactive = function(cfg){
    if(cfg === false) {
        return;
    }

    this.state = cfg ? Object.create(cfg) : {};
    this.subs = {};
};

Reactive.prototype = {
    state: {},
    subs: {},
    setters: {},

    fire: function (key, val, lastVal) {
        if (key in this.subs) {
            const subs = this.subs[key];
            for (let i = 0, _i = subs.length; i < _i; i++) {
                subs[i].call(this, this, val, lastVal);
            }
        }
    },

    sub: function (key, fn) {
        let FN, obj;// TODO unAny
        if (arguments.length === 1) {
            obj = {
                value: key in this.state ? this.state[key] : void 0
            };
            FN = function (_, val, oldVal) {
                obj.value = val;
                obj.trigger && obj.trigger(val)
            };
        } else {
            FN = fn;
        }
        (this.subs[key] || (this.subs[key] = [])).push(FN);
        if (key in this.state)
            FN.call(this, this, this.state[key]);

        return obj;
    },
    get: function(key) {
        let ptr = this.state,
            tokens = key.split('.'),
            i = 0, _i = tokens.length;
        for(;i<_i;i++){
            ptr = ptr[tokens[i]];
            if(ptr === void 0)
                return;
        }
        return ptr;
    },
    set: function (obj, statePtr, settersPtr) {
        let state, setters, key;

        if(statePtr === void 0){
            state = this.state;
            setters = this.setters;
        }else{
            state = statePtr;
            setters = settersPtr;
        }

        for (key in obj)
            this._setKey(key.split('.'), 0, obj[key], state, setters);
    },
    afterSetKey: function (key, val, lastVal) {
    },
    beforeSetKey: function (key, val, lastVal) {
        return val;
    },

    _setKey: function (key, keyCursor, val, state, setters) {

        let valueKey;

        const theKey = key[keyCursor];
        let lastVal = state[theKey];



        const isObjectVal = typeof val === 'object';
        if (lastVal === val && !isObjectVal){
            return null;
        }

        if (val instanceof Reactivity) {
            val.scope = this;
            val.key = key;
            val.emit();
            return true;
        }

        let keyInSetters = theKey in setters, setterIsFn = false;
        if(keyInSetters){
            setterIsFn = typeof setters[theKey] === 'function';
        }


        if(key.length>keyCursor+1){
            // Deeper
            if(typeof state[theKey] !== 'object'){
                state[theKey] = lastVal = {};
            }
            if (!(keyInSetters) || !(setterIsFn)){
                return this._setKey( key, keyCursor + 1, val, lastVal, setters[ theKey ] || {} );
            }else if(setterIsFn){
                let i, _i,
                    newVal = {},
                    newValPtr = newVal,
                    subKey;

                for(i = 1, _i = key.length-1; i < _i; i++){
                    subKey = key[i];
                    newValPtr[subKey] = {};
                }
                newValPtr[key[i]] = val;
                val = newVal;
            }
        }

        val = this.beforeSetKey(theKey, val, lastVal);


        if (keyInSetters) {
            if(setterIsFn){
                let setterResult = setters[ theKey ].call( this, this, val, lastVal, theKey, state );
                if(setterResult !== false){
                    state[ theKey ] = val;
                }
            }else{
                state[theKey] = val;
                if(isObjectVal){
                    if(typeof lastVal !== 'object'){
                        state[theKey] = lastVal = {};
                    }

                    // TODO if lastVal is not reactive => make it
                    for (valueKey in val){
                        this._setKey(key.concat(valueKey), keyCursor + 1, val[valueKey], lastVal, setters[theKey] || {})
                    }
                    return true;
                }
            }
        } else {
            state[theKey] = val;
            this.afterSetKey(theKey, val, lastVal);
        }

        this.fire(theKey, val, lastVal);
        return true;
    }
};

const Predefined = {
    input: {
        onChange: function() {
            this.set({checked: this.el.checked})
        }
    }
};

export const Component = function(tagName){
    // TODO supER
    Reactive.call(this);
    this.children = [];
    this.nodeName = tagName;
    if(tagName in Predefined){
        this.def = Predefined[tagName];
    }
    this._laters = {};
};

const NumberIsPx = function(_, style, prop, val) {
    //console.log(prop, val)
    if(typeof val === 'number'){
        style[prop] = val +'px';
    }else{
        style[prop] = val;
    }
};
const emptyObj = {};
const styleSetters = {
    width: NumberIsPx,
    height: NumberIsPx,
    left: NumberIsPx,
    top: NumberIsPx,
    bottom: NumberIsPx,
    right: NumberIsPx
};
Component.prototype = new Reactive();
Object.assign(Component.prototype, {
    _laterTrigger: false,
    later: function(name, fn) {
        if(!(name in this._laters)){
            this._laters[name] = fn;
        }
        if(!this._laterTrigger){
            TaskManager.add(this.laterProcessor, this);
            this._laterTrigger = true;
        }
    },
    laterProcessor: function() {
        let taskName, _laters = this._laters;
        this._laterTrigger = false;
        this._laters = {};

        for(taskName in _laters){
            _laters[taskName].call(this)
        }

    },

    nodeName: null,
    el: null,
    def: {},
    children: null,
    tree: null,
    inDOM: false,
    setters: {
        dangerouslySetInnerHTML: (_, htmlText) => _.el.innerHTML = htmlText,
        text: (_, val) => _.el.innerText = val,
        style: (_, val, lastVal, theKey, state)=>{
            if(state.style === void 0){
                state.style = {};
            }

            var style = _.el.style,
            lastStyle = lastVal || emptyObj;

            for(var i in val){
                //console.log(i, val[i])
                if(val[i] instanceof Reactivity){
                    val[i].scope = _;
                    val[i].key = ['style', i];
                    val[i].emit();
                    continue;
                }

                if(lastStyle[i] !== val[i]){
                    state.style[i] = val[i];
                    if( i in styleSetters ){
                        styleSetters[ i ].call( _, _, style, i, val[ i ] )
                    }else{
                        style[ i ] = val[ i ];
                    }
                }

            }

            // manual assign
            return false;
        }
    },

    render: function () {
        this.el = document.createElement(this.nodeName);
        return this;
    },
    init: function () {
        this.tree = this.render();
        this.el = this.tree.el;
        this.set(this.def);
    },
    renderTo: function (where) {
        where.appendChild(this.el);
    },
    mount: function(el) {
        this.renderTo(el);
        this.inDOM = true;
        this._updateChildrenSize();

        window.addEventListener('resize', ()=>{
            this.later('resize', this._updateChildrenSize);
        });
    },
    _updateChildrenSize: function() {
        if(this.inDOM){
            for( let i = 0, _i = this.children.length; i < _i; i++ ){
                const child = this.children[ i ];
                child._updateSize();
            }
        }
    },
    addChild: function (child) {
        child.renderTo(this.el);
        this.children.push(child);
        if(this.inDOM){
            child._updateSize();
        }
    },
    _updateSize: function() {
        const rect = this.getBoundingClientRect();
        if( rect ){
            this.set( { width: rect.width, height: rect.height } );
        }
    },
    beforeSetKey: function (key, val, lastVal) {
        if (key.substr(0, 2) === 'on') {
            return (e) => {
                val.call(this, e)
            };
        } else {
            return val;
        }

    },

    afterSetKey: function (key, val, lastVal) {
        if (this.el) {
            if (key.substr(0, 2) === 'on') {
                //console.log(key)
                const eventName = key.toLowerCase().substr(2);
                if (lastVal) {
                    this.un(eventName, lastVal);
                }
                this.on(eventName, val);

            } else {
                //@ts-ignore
                this.el[key] = val;
                if (val === false) {
                    this.el.removeAttribute(key);
                } else {
                    this.el.setAttribute(key, val);
                }
            }
        }
    },

    getBoundingClientRect: function() {
        return this.el.getBoundingClientRect();
    },

    on: function(eventName, fn) {
        this.el.addEventListener(eventName, fn);
    },
    un: function(eventName, fn) {
        this.el.removeEventListener(eventName, fn);
    },
    once: function(eventName, fn) {
        const wrap = () => {
            fn.apply(this, arguments);
            this.un(eventName, wrap);
        };
        this.on(eventName, wrap);
    }
});

Component._morphFnsSugar = function(cfg) {
    const res = {};
    let key, tokens, i, _i;
    for(key in cfg){
        if(key.indexOf(',')>-1){
            tokens = key.split(',');
            for( i = 0, _i = tokens.length; i < _i; i++){
                res[tokens[i]] = cfg[key]
            }
        }else{
            res[key] = cfg[key];
        }
    }

    return res;
};

Component.extend = function(name, cfg) {

    const ctor = cfg.ctor || function() {
        Component.call(this);
    };
    ctor.prototype = new Component();

    const setters = Object.assign(
        {},
        ctor.prototype.setters,
        Component._morphFnsSugar(cfg.setters)
    );
    ctor.prototype.type = name;

    Object.assign(ctor.prototype, cfg);
    ctor.prototype.setters = setters;
    ctor.extend = Component.extend;
    return ctor;
};

export const TextNode = Component.extend('TextNode', {
    setters: {
        value: (_, val)=>_.el.textContent = val
    },
    render: function(){
        this.el = document.createTextNode('');
        return this;
    },
    addChild: function (child) {
        throw new Error('No children in text node');
    },
    afterSetKey: emptyFn,
    getBoundingClientRect: ()=> null
});
const doc = new Component();
if(typeof document !== 'undefined'){
    doc.el = document;
}
Component.prototype.doc = doc;

export const h = function(ctor, props){
    let obj;
    if(typeof ctor==='string'){
        obj = new Component(ctor);
    }else {
        obj = new ctor();
    }
    obj.init();
    obj.set(props);
    for(let i = 2; i < arguments.length; i++) {
        const child = arguments[i];
        if(typeof child === 'string' || typeof child === 'number'){
            let textNode = new TextNode();
            textNode.init();
            textNode.set({value:child});
            obj.addChild(textNode);
        }else if(typeof child === 'function') {
            obj.addChild(child());
        }else{
            obj.addChild(child);
        }
    }
    return obj;
};



//export {Component, TextNode, h};