QRequire('UI.UIComponent', function(
    UIComponent
) {
    'use strict';

    return UIComponent.extend('UI.Controls', 'TextArea', {
        _prop: {
            value: 'text',
            text: {
                get: function () {
                    return this.input.value;
                },
                set: function (value) {
                    this.input.value = value;
                }
            },
            label: {
                set: function (val) {
                    this.label.innerText = val;
                }
            },

            fontSize: {
                set: function (value) {
                    this.input.style.fontSize = value;
                    this.input.style.lineHeight = value;
                }
            },

            color: {
                set: function (value) {
                    this.input.style.color = value;
                }
            },

            focused: {
                set: function (val) {
                    this.removeClass(this.el, 'Q-UI-TextArea_focused');


                    if (val === true)
                        this.addClass(this.el, 'Q-UI-TextArea_focused');

                }
            }
        }
    }, function () {
        var self = this;
        var input = document.createElement('textarea');
        this.el.className = 'Q-UI-TextArea';
        input.style['box-sizing'] = 'border-box';
        input.style['width'] = '100%';
        input.style['height'] = '100%';
        input.addEventListener('keyup', function () {
            self._propChanged('text', self.get('value'));
        });

        input.type = 'text';

        this.input = input;

        var label = this.label = document.createElement('span');
        label.className = 'Q-UI-TextArea__label';

        this.el.appendChild(input);
        this.el.appendChild(label);

        self.set('width', '400px');
        self.set('height', '400px');
    });

});