module.exports =
    QRequire('UI.UIComponent', 'observable-sequence', 'z-lib-structure-dequeue', function(
        UIComponent,
        ObservableSequence,
        dequeue
    ) {
        'use strict';
        return UIComponent.extend('UI.Controls', 'ContainerComponent', {
            /**
             *
             * @param {} item
             * @param {} prevItem
             * @param {} nextItem
             * @param {} index
             * @returns {}
             */
            _itemAddEventHandler: function (item, prevItem, nextItem, index) {
                var self = this;
                var newComp = this._wrapItem(item);

                var children = this._contentContainer ? this._contentContainer._children : this._children;

                this._handleChildren(newComp, index, index);

                newComp.on('click', function () {
                    var backgroundColor = self.get('selectionColor') || '#ffa834';
                    newComp.set('background', backgroundColor);

                    var currentIndex = self.get('selectedIndex');

                    self.fire('itemClick', self.get('itemSource').get(index));

                    if (currentIndex === index)
                        return;

                    if (currentIndex > -1)
                        children.get(currentIndex).set('background', '');
                    self.set('selectedItem', self.get('itemSource').get(index));
                    self.set('selectedIndex', index);

                    self.fire('selectionChanged', self.get('itemSource').get(index));
                });
            },
            /**
             *
             * @param {} item
             * @param {} prevItem
             * @param {} nextItem
             * @param {} index
             * @returns {}
             */
            _itemRemoveEventHandler: function (item, prevItem, nextItem, index) {
                var children = this._contentContainer ? this._contentContainer._children : this._children;
                children.splice(index, 1);
            },
            /**
             * Wrap object in ItemTemplate
             *
             * @param {Object} item
             * @returns {}
             */
            _wrapItem: function (item) {
                var template = this.get('itemTemplate');
                var newComp = new template();
                if ((typeof item !== 'object') || Array.isArray(item)) {
                    newComp.set('value', item);
                } else {
                    for (var key in item)
                        if (item.hasOwnProperty(key))
                            newComp.set(key, item[key]);
                }
                return newComp;
            },
            _handleChildren: function (newComp, index) {
                this.addChild(newComp);
            },
            _rebuildChildren: function (items) {
                var self = this;
                var children = this._contentContainer ? this._contentContainer._children : this._children;
                while (children.length)
                    children.pop();

                if (items) {
                    items.forEach(function (item, i, array) {
                        var newComp = self._wrapItem(item);
                        var index = children.length;
                        self._handleChildren(newComp, i, index);
                    });
                }
            },
            _prop: {
                value: 'itemSource',
                selectionColor: {}, //qiwi color ffa834
                selectedIndex: {
                    set: function (val) {
                        this.set('selectedItem', this.get('itemSource').get(val));
                        this.fire('selectionChanged', this.get('itemSource').get(val));
                    }
                },
                selectedItem: {
                    //set: null
                },
                itemSource: {
                    set: function (value, e) {
                        //TODO unsubscribe methods
                        var self = this;
                        var val = value;

                        if (!(value instanceof ObservableSequence) && value) {
                            if (e.oldValue instanceof ObservableSequence) {
                                value = e.oldValue;
                                while (value.length)
                                    value.pop();

                            } else {
                                value = new ObservableSequence(new dequeue());

                                value.on('add', this._itemAddEventHandler.bind(this));
                                value.on('remove', this._itemRemoveEventHandler.bind(this));
                            }

                            val.forEach(function (v) {
                                value.push(v);
                            });
                            e.value(value);
                        }

                        //this._rebuildChildren(value);
                    }
                },
                itemTemplate: {
                    set: function (val, e) {
                        if (typeof val === 'string') {
                            var template = Q.Core.TypeTable.getType(val);
                            if (template) {
                                val = template;
                            } else {
                                throw new Error('Unknown template `' + val + '`')
                            }
                        }

                        e.value(this._data.itemTemplate = val);

                        this._rebuildChildren(this.get('itemSource'));
                    }
                }
            }
        });
    });