module.exports =
    QRequire('UI.UIComponent', function(
        UIComponent
    ) {
        'use strict';
        return UIComponent.extend('UI.Controls', 'CheckBox', {
            _prop: {
                checked: {
                    get: function () {
                        return !!this.input.checked;
                    },
                    set: function (value, flags) {
                        var newValue = value === 'false' || value === '0' ? false : value;
                        if (newValue !== value)
                            flags.value(newValue);
                        this.input.checked = newValue;
                    }
                },
                label: {
                    set: function (value) {
                        this.span.innerText = value;
                    },
                    get: function () {
                    }
                },
                value: 'checked'
            }
        }, function () {
            var self = this;
            var label = document.createElement('label');

            var input = this.input = document.createElement('input');
            input.type = 'checkbox';

            this.span = document.createElement('span');

            label.appendChild(input);
            label.appendChild(this.span);

            label.className = 'Q-UI-CheckBox';
            input.addEventListener('change', function () {
                self._propChanged('checked', self.get('value'));
            });

            this.el.appendChild(label);
        });
    });