module.exports = QRequire(
    'Navigation.AbstractAnimation',
    function(
        AbstractAnimation
    ) {
        'use strict';

        return AbstractAnimation.extend('UI.Navigation', 'SwipeInAnimation', {

            play: function (newPage, callback) {
                newPage.el.style.left = '100%';
                setTimeout(function () {
                    newPage.el.style.transition = 'all 0.3s';
                    newPage.el.style.left = '0%';
                }, 20);

                setTimeout(function () {
                    newPage.el.style.transition = 'all 0s';
                    if (callback)
                        callback()
                }, 320);
            },

            playReverse: function (newPage, callback) {
                newPage.el.style.left = '0%';

                setTimeout(function () {
                    newPage.el.style.transition = 'all 0.3s';
                    newPage.el.style.left = '100%';
                }, 20);

                setTimeout(function () {
                    newPage.el.style.transition = 'all 0s';
                    if (callback)
                        callback()
                }, 320);
            }
        });
    });