module.exports = QRequire(
    'Navigation.AbstractAnimation',
    function(
        AbstractAnimation
    ) {
        'use strict';

        return AbstractAnimation.extend('UI.Navigation', 'ScaleInAnimation', {

            play: function (newPage, callback) {
                newPage.el.style.transform = 'scale(1)';
                setTimeout(function () {
                    newPage.el.style.transition = 'all 0.3s';
                    newPage.el.style.left = '0%';
                }, 20);

                setTimeout(function () {
                    newPage.el.style.transform = 'scale(1)';
                    if (callback)
                        callback()
                }, 320);
            },

            playReverse: function (newPage, callback) {
                newPage.el.style.transform = 'scale(1)';

                setTimeout(function () {
                    newPage.el.style.transition = 'all 0.3s';
                    newPage.el.style.transform = 'scale(1)';
                }, 20);

                setTimeout(function () {
                    newPage.el.style.transition = 'all 0s';
                    if (callback)
                        callback()
                }, 320);
            }
        });
    });