module.exports =
    QRequire('UI.UIComponent', 'UI.Controls.Border','UI.Controls.FlexSizeComponent', function(
        UIComponent,
        Border,
        FlexSizeComponent
    ) {
        'use strict';
        return FlexSizeComponent.extend('UI.Controls', 'VBox', {
            ctor: function () {
                this.set('height', '100%');
            },
            _createEl: function () {
                FlexSizeComponent.prototype._createEl.apply(this, arguments);
                var self = this;
                this.el.addEventListener('resize', function () {
                    self.updateLayout();
                });
            },
            updateLayout: function () {
                var self = this;
                var children = this._children;

                clearTimeout(this.updateTimeout);
                this.updateTimeout = setTimeout(function () {
                    var fDef = self._flexDefinition || {parts: [], starCount: 0, flexLength: 0, fixLength: 0};
                    var starCount = fDef.starCount;
                    if (fDef.parts.length === 0)
                        starCount = children.length;
                    var freeHeight = 100 - 100 * (fDef.fixLength / self.el.clientHeight);
                    for (var i = 0, length = children.length; i < length; i++) {
                        var fPart = fDef.parts[i];
                        var height = freeHeight / starCount + '%';
                        if (fPart) {
                            if (fPart.flex && fPart.part > 0) // 25*
                                height = freeHeight * (fPart.part / fDef.flexLength) + '%';
                            if (!fPart.flex) { // 25
                                height = fPart.part + 'px';
                            }
                        } else {
                            height = freeHeight / starCount + '%';
                        }
                        children.get(i).set('height', height);
                    }
                }, 0);
                FlexSizeComponent.prototype.updateLayout.call(this);
            },
            addChild: function (child) {
                var div = new Border({
                    width: '100%'
                });
                div.addChild(child);
                this._children.push(div);

                this.updateLayout();
            }
        });
    });