module.exports =
    QRequire('UI.UIComponent', 'UI.ContentContainer', function(
        UIComponent,
        ContentContainer
    ) {
        'use strict';

        return UIComponent.extend('UI.Controls', 'GovnoControl', {
            createEl: function () {
                var self = this;
                this.el = document.createElement('div');
                this.el.id = 'GovnoControlTable';
                this.el.style.width = '500px';
                this.el.style.height = '300px';

                setTimeout(function () {
                    self.govnotable = $('#GovnoControlTable').editTable({
                        data: [['date', new Date().toLocaleDateString()], ['amount', '500'], ['comission', '5']],
                        first_row: false,
                        headerCols: [
                            'Key',
                            'Value'
                        ]
                    });
                    $('#GovnoControlTable').on('keyup', 'input', function () {
                        self.set('data', self.get('data'));
                    });
                }, 100);

            },
            _prop: {
                data: {
                    get: function () {
                        var tdata = this.govnotable ? this.govnotable.getData() : [];
                        var data = {};

                        for (var i = 0; i < tdata.length; i++) {
                            var record = tdata[i];
                            data[record[0]] = record[1];
                        }

                        return data;
                    }
                }
            }
        });
    });