module.exports =
    QRequire('UI.UIComponent', 'UI.ContentContainer', function(
        UIComponent,
        ContentContainer
    ) {
        'use strict';

        return UIComponent.extend('UI.Controls', 'FlexSizeComponent', {
            _prop: {
                value: 'flexDefenition',
                flexDefinition: {
                    set: function (value) {
                        var flexDefinition = {parts: [], starCount: 0, flexLength: 0, fixLength: 0};
                        var stringParts = value.split(' ');

                        for (var i = 0; i < stringParts.length; i++) {
                            var fPart = stringParts[i];

                            if (fPart.length === 0) continue;

                            var newPart = {part: 0, flex: true};

                            var parsedFloat = parseFloat(fPart);
                            if (fPart[fPart.length - 1] === '*') {
                                newPart.flex = true;

                                if (!parsedFloat) {
                                    flexDefinition.starCount += 1;
                                } else {
                                    newPart.part = parsedFloat;
                                    flexDefinition.flexLength += parsedFloat;
                                }

                            } else {
                                newPart.flex = false;
                                newPart.part = parsedFloat;
                                flexDefinition.fixLength += parsedFloat;
                            }

                            flexDefinition.parts.push(newPart);
                        }
                        this._flexDefinition = flexDefinition;
                        this.updateLayout();
                    }
                }
            }
        });
    });