/**
 * Created by ravenor on 13.07.16.
 */
module.exports =
    QRequire('UI.UIComponent', 'UI.ContentContainer', function(
        UIComponent,
        ContentContainer
    ) {
    'use strict';

    return UIComponent.extend('UI.Controls', 'Border', {
        ctor: function () {
            this._ownComponents.push(new ContentContainer());
            this.el.style.overflow = 'visible';
            this._contentContainer.setAll({
                pureCss: 'position: absolute; top: 0; bottom: 0; right: 0; left: 0; width:auto; height: auto'
            });
        },
        _prop: {
            margin: {
                set: function (value) {
                    var parts = value.split(/\s{1,}/g);

                    var css = '';

                    if (parts.length === 4) {
                        css = 'position: absolute; top: ' + parts[0] + '; bottom: ' + parts[2] + '; right:' + parts[1] + '; left: ' + parts[3];
                    } else if (parts.length === 3) {
                        css = 'position: absolute; top: ' + parts[0] + '; bottom: ' + parts[2] + '; right:' + parts[1] + '; left: ' + parts[1];
                    } else if (parts.length === 2) {
                        css = 'position: absolute; top: ' + parts[0] + '; bottom: ' + parts[0] + '; right:' + parts[1] + '; left: ' + parts[1];
                    } else if (parts.length === 1) {
                        css = 'position: absolute; top: ' + parts[0] + '; bottom: ' + parts[0] + '; right:' + parts[0] + '; left: ' + parts[0];
                    }

                    this._contentContainer.set('pureCss', css);
                }
            },
            borderRadius: {
                set: function (value) {
                    this._contentContainer.el.style.borderRadius = value;
                }
            }
        }
    });
});