module.exports =
    QRequire('Core.AbstractComponent', 'Core.QObject','Core.Pipe', function(
        AbstractComponent,
        QObject,
        Pipe
    ) {
        'use strict';

        var console = {
            log: function () {
            }
        };
        var base = AbstractComponent.prototype;

        /** @class */
        var RunAtServerComponent = AbstractComponent.extend('Core', 'RunAtServerComponent', {
            ctor: function () {
                this.socket = void(0);
                this.listeners = {};
                this._sync = false;

                if (typeof io !== "undefined") {
                    this.__side = 'client';
                    this.socket = io(void 0, this);
                    this.appName = ((((((Q || {}).UI || {}).Navigation || {}).NavigationManager || {}).Application || {}).current || {}).name;
                    this._initSocket();

                } else {
                    this.__side = 'server';
                }
            },
            '~destroy': function () {
                if (this.socket) {
                    this.socket.emit('~destroy');
                    this.socket['~destroy']();
                }
            },

            _initSocket: function () {
                if (!this.socket)
                    return;

                var socket = this.socket;
                var self = this;

                socket.on('set', function (data) {
                    self._sync = true;
                    self.set(data.key, data.value, true);
                    self._sync = false;
                });
                socket.on('call', function (data) {
                    self.call.apply(self, data.args);
                });
                socket.on('sync', function (data) {
                    self.call.apply(self, data.args);
                });
                socket.on('resolve', function (data) {
                    self._sync = true;
                    self.set(data.key, data.data);
                    console.log('resolve', data.key, self.__refs[data.key[0]], self.____id, data, self);
                    /*self.__refs[data.key[0]].forEach(function (r) {
                     r.resolve(data.data);
                     });*/
                    self._sync = false;
                });
                socket.on('ref', function (data) {
                    var ref = self.ref(data.key);
                    ref.subscribe(function (result) {
                        socket.emit('resolve', {key: data.key, data: result})
                    });
                    socket.emit('resolve', {key: data.key, data: ref.get()})
                });

                socket.on('RPC', function (data) {
                    var fn = self['#' + data.fn], out;
                    if (!fn)
                        out = {error: true, val: 'No function `' + data.fn + '`'};
                    else {
                        try {
                            out = {error: false, val: fn.apply(self, data.args)};
                        } catch (e) {
                            out = {error: true, val: e.message + '\n' + e.stack};
                        }
                    }

                    socket.emit('responseRPC', {id: data.id, data: out});
                });
                socket.on('responseRPC', function (data) {
                    var cbs = self.___RPCcallbacks;
                    if (cbs) {
                        if (cbs[data.id]) {
                            var val = data.data;
                            if (val.error)
                                throw new Error(val.val);
                            else
                                cbs[data.id].call(self, val.val);
                        }
                    }
                });

                if (this.__side === 'client') {
                    socket.on('fireClient', function (data) {
                        self.fire.apply(self, data);
                    });
                    socket.emit('start', {namespace: this.namespace, type: this.type, appName: this.appName});
                } else {
                    socket.on('~destroy', function () {
                        self['~destroy'] && self['~destroy']();
                        self.fire('~destroy');
                    });
                }
            },
            fireClient: function () {
                this.socket.emit('fireClient', [].slice.call(arguments));
            },
            _connectSocket: function (socket) {
                this.socket = socket;
                this._initSocket();
                this.setAll(this._data);
            },
            _RPC: function (name, args) {

                args = [].slice.call(args);
                var cb,
                    cbs = this.___RPCcallbacks = this.___RPCcallbacks || {};

                if (!('___RPCID' in this))
                    this.___RPCID = 0;

                this.___RPCID++;

                if (args.length && typeof args[args.length - 1] === 'function') {
                    cb = args.pop();
                    cbs[this.___RPCID] = cb;
                }
                this.socket.emit('RPC', {
                    fn: name,
                    args: args,
                    id: this.___RPCID
                });
            },
            ref: function (key) {
                var ref = base.ref.call(this, key);

                if (this.__side === 'client') {
                    this.socket.emit('ref', {key: key});
                    //this.listeners[key] = ref;
                }

                return ref;
            },
            set: function (key, value, silent) {
                var data = {};
                var toSetVal = value;

                var ret = base.set.call(this, key, value);

                data[key] = toSetVal instanceof QObject ? toSetVal.serialize() : toSetVal;
                if (this.socket && !this._sync) {
                    this.socket.emit('set', {key: key, value: data[key]});
                }

                return ret;
            },
            call: function () {
                if (this.__side === 'client') {
                    this.socket.emit('call', {args: Array.from(arguments)});
                }
                if (this.__side === 'server') {
                    base.call.apply(this, arguments);
                }
            }
        });

        return RunAtServerComponent;
    });