var AbstractAnimation = require('./AbstractAnimation');

var TypeTable =
    typeof Q != "undefined"
        ? Q.Core.TypeTable
        : require("../../Core/TypeTable");

var QObject = TypeTable.getType('Core', "QObject");

module.exports = AbstractAnimation.extend('UI.Navigation', 'SwipeInAnimation', {

    play: function (newPage, callback) {
        newPage.el.style.left = '100%';
        setTimeout(function () {
            newPage.el.style.transition = 'all 0.3s';
            newPage.el.style.left = '0%';
        }, 20);

        setTimeout(function () {
            newPage.el.style.transition = 'all 0s';
            if (callback)
                callback()
        }, 320);
    },

    playReverse: function (newPage, callback) {
        newPage.el.style.left = '0%';

        setTimeout(function () {
            newPage.el.style.transition = 'all 0.3s';
            newPage.el.style.left = '100%';
        }, 20);

        setTimeout(function () {
            newPage.el.style.transition = 'all 0s';
            if (callback)
                callback()
        }, 320);
    }
});