var AbstractAnimation = require('./AbstractAnimation');

var TypeTable =
    typeof Q != "undefined"
        ? Q.Core.TypeTable
        : require("../../Core/TypeTable");

var QObject = TypeTable.getType('Core', "QObject");

module.exports = AbstractAnimation.extend('UI.Navigation', 'ScaleInAnimation', {

    play: function (newPage, callback) {
        newPage.el.style.transform = 'scale(0.2)';
        newPage.el.style.opacity = '0';
        setTimeout(function () {
            newPage.el.style.transition = 'all 0.3s';
            newPage.el.style.transform = 'scale(1)';
            newPage.el.style.opacity = '1';
        }, 20);

        setTimeout(function () {
            if (callback)
                callback()
        }, 320);
    },

    playReverse: function (newPage, callback) {
        newPage.el.style.transform = 'scale(1)';
        newPage.el.style.opacity = '1';

        setTimeout(function () {
            newPage.el.style.transition = 'all 0.3s';
            newPage.el.style.transform = 'scale(0.2)';
            newPage.el.style.opacity = '0';
        }, 20);

        setTimeout(function () {
            newPage.el.style.transition = 'all 0s';
            if (callback)
                callback()
        }, 320);
    }
});