var AbstractAnimation = require('./AbstractAnimation');
var SwipeInAnimation = require('./SwipeInAnimation');
var SwipeOutAnimation = require('./SwipeOutAnimation');

var ScaleInAnimation = require('./ScaleInAnimation');

var TypeTable =
    typeof Q != "undefined"
        ? Q.Core.TypeTable
        : require("../../Core/TypeTable");

var QObject = TypeTable.getType('Core', "QObject");

function getViewport() {
    return document.getElementById('viewport');
}

function webGet(url, callback) {
    var xmlhttp = new XMLHttpRequest();

    xmlhttp.open('GET', url, true);
    xmlhttp.onreadystatechange = function () {
        if (xmlhttp.readyState === 4) {
            if (xmlhttp.status === 200) {
                callback(null, xmlhttp.responseText)
            }
        }
    };
    xmlhttp.send(null);
}

/** @class */
var NavigationManager = QObject.extend('UI.Navigation', 'NavigationManager', {});

NavigationManager.defaultAnimation = new ScaleInAnimation();
NavigationManager.applicationStack = [];
NavigationManager.busy = false;

var Application = function (src, name) {
    this.navigationStack = [];
    this.el = document.createElement('div');
    this.el.classList.add('Application');
    this.el.style.height = '100%';
    this.el.style.width = '100%';
    this.fadeInAnimation = new SwipeOutAnimation();
    this.fadeOutAnimation = new SwipeInAnimation();
    this.currentPage = void(0);

    this.name = name;

    if (src)
        this.setSource(src);
};

Application.prototype = {
    setSource: function (src) {
        var newSrc = '(function(){';
        newSrc += src;
        newSrc += ' return _AppNamespace })()';

        var ns = eval(newSrc);
        this.namespace = ns;
    },
    canGoBack: function () {
        return this.navigationStack.length > 1;
    },
    navigate: function (to, cfg) {
        if (this.busy) return;
        this.busy = true;

        var self = this;
        cfg = cfg || {};

        var viewport = this.el;

        var targetPageCtor = TypeTable.getType(this.namespace, to);
        if (targetPageCtor) {
            var nextPage = new targetPageCtor();

            var fadeOutAnim = cfg.fadeOut || nextPage.get('fadeOutAnimation') || this.fadeOutAnimation;

            var currentPage = this.navigationStack[0];
            if (!currentPage) {
                viewport.appendChild(nextPage.el);
                //fadeOutAnim.play(nextPage, function () {
                nextPage.load(true);
                self.busy = false;
                self.currentPage = nextPage;
                nextPage.updateLayout();
                !cfg.silent && NavigationManager.fire('pageChanged', nextPage);
                //});
            } else {

                var fadeInAnim = cfg.fadeIn || currentPage.get('fadeInAnimation') || this.fadeInAnimation;

                fadeInAnim.play(currentPage);
                fadeOutAnim.play(nextPage, function () {
                    viewport.removeChild(currentPage.el);
                    nextPage.load(true);
                    self.busy = false;
                    self.currentPage = nextPage;
                    nextPage.updateLayout();
                    !cfg.silent && NavigationManager.fire('pageChanged', nextPage);
                });
                viewport.appendChild(nextPage.el);
            }
            this.navigationStack.unshift(nextPage);
        }else{
            console.error('Page '+ [this.namespace, to].join('.')+' does not exists');
            this.busy = false;
        }
    },
    back: function (cfg) {
        if (this.canGoBack()) {
            if (this.busy) return;
            this.busy = true;

            var self = this,
                getTheHellOutOfHere = false;

            var currentPage = this.navigationStack.shift();
            var backPage = this.navigationStack[0];

            cfg = cfg || {};
            var fadeOutAnim = cfg.fadeOut || currentPage.get('fadeOutAnimation') || this.fadeOutAnimation;
            var fadeInAnim = cfg.fadeIn || backPage.get('fadeInAnimation') || this.fadeInAnimation;

            if( typeof currentPage['~beforeDestroy'] === 'function' ){
                if(currentPage['~beforeDestroy']() === false) {
                    getTheHellOutOfHere = true;
                    self.busy = false;
                    return false;
                }
            }

            var viewport = this.el;
            viewport.appendChild(backPage.el);
            fadeInAnim.playReverse(backPage);
            fadeOutAnim.playReverse(currentPage, function () {
                viewport.removeChild(currentPage.el);
                typeof currentPage['~destroy'] === 'function' && currentPage['~destroy']();

                backPage.load(true);
                self.busy = false;
                self.currentPage = backPage;
                backPage.updateLayout();
                NavigationManager.fire('pageChanged', backPage);
            });
        }
    },
    '~destroy': function(){
        this.navigationStack.forEach(function(page){
            typeof page['~destroy'] === 'function' && page['~destroy']();
        });
    }
}
;
Application.current = void(0);


NavigationManager.load = function (appName, cb) {
    var app = appName;

    if (app.slice(0, -3) !== '.qs') {
        app += '.qs';
    }
    webGet('/Apps/' + app, function (err, data) {
        console.log(data);
        if(cb) {
            return cb(new Application(data, appName));
        }
        if (NavigationManager.busy) return;
        NavigationManager.busy = true;

        var app = new Application(data, appName);


        Application.current = app;
        var viewport = getViewport();
        app.navigate('main');
        var anim = NavigationManager.defaultAnimation;
        viewport.appendChild(app.el);
        anim.play(app, function () {
            if (NavigationManager.applicationStack.length > 0) {
                var prevApp = NavigationManager.applicationStack[0];
                getViewport().removeChild(prevApp.el);
            }
            NavigationManager.applicationStack.unshift(app);
            NavigationManager.busy = false;
            NavigationManager.fire('loaded', app);
        });

    });
};
NavigationManager.on = Q.Core.QObject.prototype.on;
NavigationManager.fire = Q.Core.QObject.prototype.fire;
NavigationManager.eventList = {};

NavigationManager.navigate = function (to, cfg) {
    if (NavigationManager.busy) return;

    Application.current.navigate(to, cfg);
};

NavigationManager.canGoBack = function () {
    return NavigationManager.applicationStack.length > 1;
};

NavigationManager.back = function (cfg) {

    if (Application.current.canGoBack()) {
        Application.current.back(cfg);
    } else {
        if (NavigationManager.canGoBack()) {
            if (NavigationManager.busy) return;
            NavigationManager.busy = true;

            var currentApp = NavigationManager.applicationStack.shift();
            var backApp = NavigationManager.applicationStack[0];

            var viewport = getViewport();
            viewport.insertBefore(backApp.el, currentApp.el);

            NavigationManager.defaultAnimation.playReverse(currentApp, function () {

                typeof currentApp['~destroy'] === 'function' && currentApp['~destroy']();

                Application.current = backApp;
                viewport.removeChild(currentApp.el);
                NavigationManager.busy = false;
                backApp.currentPage.updateLayout();
                NavigationManager.fire('pageChanged', backApp.currentPage);
            });

        }
    }

};

NavigationManager.Application = Application;
module.exports = NavigationManager;