var TypeTable =
    typeof Q != "undefined"
        ? Q.Core.TypeTable
        : require("../../Core/TypeTable");

var QObject = TypeTable.getType('Core', "QObject");

var AbstractAnimation = QObject.extend('UI.Navigation', 'AbstractAnimation', {
    ctor: function () {
        this.set('duration', 300);
        this.set('startCss', '');
        this.set('endCss', '');
    },
    play: function (target, callback) {
        var self = this;
        target.set('pureCss', this.get('startCss'));

        setTimeout(function () {
            target.set('pureCss', 'transition: all ' + self.get('duration') / 1000 + 's');
            target.set('pureCss', self.get('endCss') + ';transition: all ' + self.get('duration') / 1000 + 's');
        }, 0);
        setTimeout(function () {
            if (callback) callback();
        }, this.get('duration'));
    },
    playReverse: function (target, callback) {
        var self = this;
        target.set('pureCss', this.get('endCss') + ';transition: all ' + this.get('duration') / 1000 + 's');
        setTimeout(function () {
            target.set('pureCss', self.get('startCss') + ';transition: all ' + self.get('duration') / 1000 + 's');
        }, 0);
        setTimeout(function () {
            if (callback) callback();
        }, this.get('duration'));
    },
    _prop: {
        duration: {},
        startCss: {},
        endCss: {}
    }
});

module.exports = AbstractAnimation;