var UIComponent = require('../UIComponent');
var ContainerComponent = require('./ContainerComponent');

var base = UIComponent.prototype;

module.exports = ContainerComponent.extend('UI.Controls', 'WrapPanel', {
    updateLayout: function () {
        var self = this;

        setTimeout(function () {
            var iterator = self._children.iterator(), item;
            while (item = iterator.next()) {
                if (item instanceof UIComponent) {
                    item.set('width', self.get('itemWidth'));
                }
            }
        }, 0);

        base.updateLayout.call(this);
    },
    _handleChildren: function (childComp, index) {
        var self = this;
        var childNode = childComp.el;
        childComp.set('width', this.get('itemWidth'));

        //TODO rewrite to native properties
        childNode.style.float = 'left';
        childNode.style.position = 'relative';
        childNode.style.overflow = 'hidden';

        childNode.addEventListener('click', function () {
            self.set('selectedIndex', index);
            self.fire('itemClick', self.get('selectedItem'), index);
        });
    },
    _prop: {
        itemWidth: {
            set: function () {
                this.updateLayout();
            }
        }
    }
});