var UIComponent = require('../UIComponent');

module.exports = UIComponent.extend('UI.Controls', 'Video', {
    updateLayout: function () {
        this.set('value', this.get('value'));
    },
    ctor: function () {
        this.set('value', 'https://www.w3schools.com/html/mov_bbb.mp4');
    },
    play: function () {
        this.el.play();
    },
    stop: function () {
        this.el.pause();
    },
    pause: function () {
        this.el.pause();
    },
    createEl: function () {
        var self = this;
        this.el = document.createElement('video');

        this.el.addEventListener('timeupdate', function (event) {
            self.updating = true;
            self.set('time', self.el.currentTime);
            self.updating = false;
        });
        this.el.addEventListener('volumechange', function (event) {
            self.updating = true;
            self.set('volume', self.el.volume);
            self.updating = false;
        });
        this.el.addEventListener('durationchange', function (event) {
            self.set('duration', self.el.duration);
        });
        this.el.addEventListener('click', function () {
            self.fire('click');
        });
    },
    _prop: {
        time: {
            set: function (value) {
                if (!this.updating) {
                    this.el.currentTime = value;
                }
            }
        },
        duration: {},
        volume: {
            description: 'Current volume',
            get: function () {
                return this.el.volume * 100;
            },
            set: function (value) {
                if (!this.updating)
                    this.el.volume = value / 100;
            }
        },
        controls: {
            get: function () {
                return this.el.controls;
            },
            set: function (value) {
                this.el.controls = value;
            }
        },
        muted: {
            get: function () {
                return this.el.muted;
            },
            set: function (value) {
                this.el.muted = value;
            }
        },
        fullscreen: {
            get: function () {
                return !!(document.fullscreenElement);
            },
            set: function (value) {
                if (value) {
                    var el = this.el;
                    if (el.requestFullscreen) {
                        el.requestFullscreen();
                    } else if (el.mozRequestFullScreen) {
                        el.mozRequestFullScreen();
                    } else if (el.webkitRequestFullScreen) {
                        el.webkitRequestFullScreen();
                    }
                } else {
                    var doc = UIComponent.document;
                    if (doc.exitFullscreen) {
                        doc.exitFullscreen();
                    } else if (doc.cancelFullscreen) {
                        doc.cancelFullscreen();
                    } else if (doc.mozCancelFullScreen) {
                        doc.mozCancelFullScreen();
                    }
                }
            }
        },
        autoplay: {
            set: function (value) {
                if (value)
                    this.play();
            }
        },
        loop: {
            set: function (value) {
                this.el.loop = value;
            }
        },
        value: 'source',
        source: {
            set: function (value) {
                this.stop();
                this.el.src = value;

                if (this.get('autoplay')) {
                    this.play();
                }
            }
        }
    }
});
