var UIComponent = require('../UIComponent');

module.exports = UIComponent.extend('UI.Controls', 'TextBox', {
    ctor: function () {
        var self = this;
        var input = document.createElement('input');

        this.el.className = 'Q-UI-TextBox';

        input.style['box-sizing'] = 'border-box';
        input.style['width'] = '100%';
        input.addEventListener('keyup', function () {
            self._propChanged('text', self.get('value'));
        });

        input.type = 'text';

        this.input = input;
        var label = this.label = document.createElement('span');
        label.className = 'Q-UI-TextBox__label';

        this.el.appendChild(input);
        this.el.appendChild(label);

        this.set('padding', '0 40px');

        this.on('click', function(){
            self.delegate.activate(self);
        });
    },

    _tabProtocolReceive: function(info){
        if(info.action === 'backspace'){
            this.input.value = this.input.value.substr(0,this.input.value.length-1);
        }else
        this.input.value += info.key;
    },
    _tabProtocol: function (delegate) {
        if(delegate) {
            this.delegate = delegate;
            return true;
        }
        this.el.classList.add('Focused');
        var input = this.input;
        setTimeout(function(){
            input.focus();
        },5);
        this.delegate.layout && this.delegate.layout(this.get('layout'));

    },
    _tabProtocolLeave: function(){
        this.el.classList.remove('Focused');
        this.delegate.layout && this.delegate.layout('none');
    },
    _prop: {
        value: 'text',
        text: {
            get: function () {
                return this.input.value;
            },
            set: function (value) {
                this.input.value = value;
            }
        },
        placeholder: {
            get: function () {
                return this.input.placeholder;
            },
            set: function (placeholder) {
                this.input.placeholder = placeholder;
            }
        },
        color: {
            get: function () {
                return this.input.style.color;
            },
            set: function (value) {
                this.input.style.color = value;
            }
        },

        label: {
            set: function(val){
                this.label.innerText = val;
            }
        },

        focused: {
            set: function(val){
                this.removeClass(this.el,'Q-UI-TextBox_focused');
                

                if(val === true)
                    this.addClass(this.el,'Q-UI-TextBox_focused');

            }
        }

    }
});
