var UIComponent = require('../UIComponent');

var height = 20;
var pad = height / 8;

module.exports = UIComponent.extend('UI.Controls', 'Slider', {
    ctor: function () {
        this.set('from', 0);
        this.set('to', 100);
        this.set('step', 1);
        this.set('value', 50);
    },
    createEl: function () {
        var _self = this;
        var el = this.el = UIComponent.createElementCss('div', {
            position: 'relative',
            height: height + 'px',
            minHeight: height +'px'
        });
        this.el.draggable = false;

        this.back = UIComponent.createElementCss('div', {
            background: '#ddd',
            height: height - pad * 2 + 'px',
            left: height / 2 + 'px',
            right: height / 2 + 'px',
            top: pad + 'px',
            position: 'absolute'
        });

        this.left = UIComponent.createElementCss('div', {
            background: '#e00',
            height: height - pad * 2 + 'px',
            left: height / 2 + 'px',
            right: height / 2 + 'px',
            top: pad + 'px',
            position: 'absolute'
        });

        this.right = UIComponent.createElementCss('div', {});

        this.drag = UIComponent.createElementCss('div', {
            background: '#e00',
            width: (height - 2) + 'px',
            height: (height - 2) + 'px',
            top: '1px',
            //'margin-left': -(height / 2) +'px',
            //background: '#FF0',
            left: '50%',
            position: 'absolute',
            cursor: 'pointer',
            'border-radius': height / 2 + 'px',
            'box-shadow': '0 0 1px #000'
        });

        this.el.appendChild(this.back);
        this.el.appendChild(this.left);
        this.el.appendChild(this.right);
        this.el.appendChild(this.drag);

        this.left.draggable = false;
        this.drag.draggable = false;
        this.right.draggable = false;
        this.back.draggable = false;

        var mouseMoveListener = function (e) {
            _self._getInfo();
            update(e);
        };

        var update = function (e) {
            var x = e.clientX - left;
            _self.updateValuePercent((x - height / 2) / (width - height));
        };

        var width, left;

        this.el.addEventListener('mousedown', function (e, name, el) {

            _self._getInfo();
            var bound = _self.el.getBoundingClientRect();
            width = bound.width;
            left = bound.left;
            update(e);

            e.preventDefault();
            document.addEventListener('mousemove', mouseMoveListener);
        });

        document.addEventListener('mouseup', function (e, name, el) {
            document.removeEventListener('mousemove', mouseMoveListener);
        });

    },
    updateLayout: function () {
        this._getInfo();
        this.set('value', this.get('value'));
    },
    updateValuePercent: function (val) {
        this._getInfo;
        this.set('value', val * (this._data.to - this._data.from) + this._data.from);
    },

    _getInfo: function (e) {
        var self = this;
        return this.info = {
            from: self.get('from'),
            to: self.get('to'),
            step: self.get('step'),
            width: this.el.clientWidth,
            left: e && e.target.offsetLeft,
            x: e && e.clientX,
            y: e && e.clientY
        };
    },
    _prop: {
        value: '_value',
        _value: {
            set: function (val, e) {
                this._getInfo();

                val = val || 0;
                var info = this.info || this._getInfo();
                var wid, pos,
                    step = info.step - 0, from = info.from - 0, to = info.to - 0, delta = to - from;

                val < from && (val = from);
                val > to && (val = to);

                if (step)
                    val = Math.round(val / step) * step;

                wid = (val - from) / delta * (info.width - height);

                this.drag.style.left = wid + 'px';
                this.left.style.width = wid + 'px';

                e.value(val);
            }
        },
        from: {
            set: function (val) {
                this._getInfo();
                this.updateLayout();
            }
        },
        to: {
            set: function (val) {
                this._getInfo();
                this.updateLayout();
            }
        },
        step: {
            set: function (val) {
                this._getInfo();
                this.updateLayout();
            }
        },
        fillColor: {
            set: function (val) {
                this.left.style.background = val;//('left,drag', {background: val});
                this.drag.style.background = val;
            }
        }

    }
});
