var UIComponent = require('../UIComponent');
var ContainerComponent = require('./ContainerComponent');

var base = UIComponent.prototype;

module.exports = ContainerComponent.extend('UI.Controls', 'ListBox', {
    ctor: function () {
        this.setAll({
            scroll: 'vertical',
            height: '100%'
        });
    },
    _formatChild: function (childComp) {
        var childNode = childComp.el;
        childNode.style.position = 'relative';

        if (this._data.orientation === 'horizontal') {
            childNode.style.float = 'left';
            childNode.style.clear = 'none';
        }
        if (this._data.orientation === 'vertical') {
            childNode.style.float = 'none';
            childNode.style.clear = 'both';
        }
    },
    _handleChildren: function (childComp, index) {
        var self = this;
        this._formatChild(childComp);
        var childNode = childComp.el;

        /*
         childNode.addEventListener('click', function () {
         self.set('selectedIndex', index);
         self.fire('select', index);
         });
         childNode.addEventListener('mouseover', function () {
         if (self.get('hoverMode')) {
         self.set('selectedIndex', index);
         }
         });
         */
    },
    _prop: {
        hoverMode: {},
        orientation: {
            set: function (value) {
                var iterator = this._children.iterator(), item;

                while (item = iterator.next()) {
                    this._formatChild(item);
                }
            }
        }
    }
});
