/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 * *
 */
;// QUOKKA 2017
// By zibx on 5/23/17.

module.exports = (function () {
    'use strict';
    var layouts = {
        none: [],
        'ru': [
            ['йцукенгшщзхъ'],
            ['фывапролджэ'],
            ['ячсмитьбю', {"text":"", "cls": "del", action: 'backspace'}],
            [{"text":" ", "value": " ", "width": "408", "cls": "space"}]
        ],
        'en': [
            ['qwertyuiop'],
            ['asdfghjkl'],
            ['zxcvbnm', {"text":"", "cls": "del", action: 'backspace'}],
            [{"text":" ", "value": " ", "width": "408", "cls": "space"}]
        ]
    };
    var big = function (name) {
        var layout = layouts[name],
            bigName = name.toUpperCase(),

            newLayout = layout.map(function (row) {
                return row.map(function (item) {
                    if(typeof item === 'string')
                        return item.toUpperCase();
                    else
                        return item;
                });
            });
        layouts[bigName] = newLayout;
    };

    big('ru');
    big('en');

    var UIComponent = require('../UIComponent');
    var counter = 0;
    var keyStorage = {};
    var Key = function (cfg) {
        Object.assign(this, cfg);
        this.el = document.createElement('div');
        this.el.innerText = this.text;
        var cls = [''];
        if(cfg.cls)
            cls = cls.concat(cfg.cls);

        this.el.className = cls.map(function(name){return 'kb-btn'+(name?'--'+name:'')}).join(' ');
        this.id = counter;
        this.el.setAttribute('data-val', this.id);
        counter++;
        keyStorage[this.id] = this;
    };
    Key.prototype = {
        el: null,
        text: '',
        value: '',
        id: 0
    };
    var layoutsCache = {};

    var simpleKey = function (cfg) {
      return new Key({text: cfg, value: cfg});
    };
    return UIComponent.extend('UI.Controls', 'Keyboard', {
        _tabProtocol: function(delegate){
            if(delegate){
                this.delegate = delegate;
                var _self = this;
                delegate.layout = function(val){
                    _self.set('layout', val);
                };
                return false;
            }else{
                this.delegate.skip();
            }
        },
        ctor: function(){
            var origin,
                _self = this;
            var currentKey;
            var up = function(e){
                window.removeEventListener('mouseup', up);
                /*if(e.target === origin){

                }*/
                var val = origin.getAttribute('data-val'),
                    key = keyStorage[val];
                currentKey.el.classList.remove('Over');
                if(key === currentKey){
                    _self.delegate.send({e: e, key: key.text, action: key.action});
                    console.log(key)
                }
                e.preventDefault();

            };
            this.el.addEventListener('mousedown', function(e){
                origin = e.target;
                var val = origin.getAttribute('data-val');
                if(val) {
                    currentKey = keyStorage[val];
                    currentKey.el.classList.add('Over');
                }
                e.preventDefault();
                window.addEventListener('mouseup', up);

            });
            window.addEventListener('keydown', function(e){
                console.log(e.key, e.key.length,e.which,e);
                if(e.which === 9) {
                    if(e.shiftKey){
                        _self.delegate.prev();
                    }else {
                        _self.delegate.next();
                    }
                    e.preventDefault();
                    e.stopPropagation();
                }
            });
            window.addEventListener('keypress', function(e){
                _self.delegate.send({e: e, key: e.key});
                e.preventDefault();
                e.stopPropagation();
            });
        },
        lastLayoutName: void 0,
        changeLayout: function(){

            var lastLayoutName = this.lastLayoutName,
                layoutName = this.get('layout'),
                layoutConfig, rows, layout;
            if(lastLayoutName === layoutName)
                return;

            if(!layoutsCache[layoutName]){ // if not cached

                layoutConfig = layouts[layoutName]; // get config

                rows = layoutConfig.map(function (line) { // get all rows
                    var rowKeys,
                        row;

                    rowKeys = [].concat.apply([], line.map(function (item) { // join all keys in single array
                        if (typeof item === 'string') {
                            return item.split('').map(simpleKey)
                        } else {
                            return new Key(item);
                        }
                    }));

                    row = { // create row object
                        keys: rowKeys,
                        el: document.createElement('div')
                    };
                    row.el.className = 'kb-row';
                    rowKeys.forEach(function (key) {
                        row.el.appendChild(key.el); // append all child elements to row element
                    });

                    return row;
                });

                layout = layoutsCache[layoutName] = { // store to cache
                    el: document.createElement('div'),
                    rows: rows
                };
                layout.el.className = 'kb';

                rows.forEach(function (row) { // add rows elements to layout element
                    layout.el.appendChild(row.el);
                });
            }else{
                layout = layoutsCache[layoutName];
            }
            this.el.appendChild(layout.el);

            if(lastLayoutName){
                this.el.removeChild(layoutsCache[lastLayoutName].el);
            }

            this.lastLayoutName = layoutName;
        },
        _prop: {
            layout: {
                set: function(value, e){
                    if(!layouts[value]){
                        value = e.oldValue;
                        console.log('Incorrect keyboard layout `'+ value +'`, switched back to `'+ e.oldValue +'`');
                    }
                    e.value(value);
                    this.changeLayout();
                }
            }
        }
    });
})();