var UIComponent = require('../UIComponent');

module.exports = UIComponent.extend('UI.Controls', 'Image', {
    createEl: function () {
        this.el = document.createElement('div');
        this.elStyle = this.el.style;
        this.elStyle.backgroundPosition = 'center';
        this.elStyle.backgroundRepeat = 'no-repeat';
    },
    _prop: {
        value: 'source',
        source: {
            set: function (value) {
                this.elStyle.backgroundImage = 'url(' + value + ')';
            }
        },
        stretch: {
            set: function (value) {
                switch (value) {
                    case 'none':
                        this.elStyle.backgroundSize = 'auto auto';
                        break;
                    case 'fill':
                        this.elStyle.backgroundSize = '100% 100%';
                        break;
                    case 'uniform':
                        this.elStyle.backgroundSize = 'contain';
                        break;
                    case 'uniformToFill':
                        this.elStyle.backgroundSize = 'cover';
                        break;
                    default:
                        this.elStyle.backgroundSize = 'auto auto';
                }
            }
        },
    }
});