/**
 * Created by ravenor on 13.07.16.
 */

var UIComponent = require('../UIComponent');

module.exports = UIComponent.extend('UI.Controls', 'GeoMap', {
    createEl: function () {
        var self = this;

        this.id = "8249t7cjnap8otmw89yuao4867ta209";

        this.el = document.createElement('div');
        this.el.style.width = '100%';
        this.el.style.height = '100%';
        this.el.id = this.id;

        this.set('home', [55.76, 37.64]);
        this.set('zoom', 11);

        var script = document.createElement("script");
        script.src = 'https://api-maps.yandex.ru/2.1/?lang=en_US';
        document.head.appendChild(script);

        script.addEventListener('load', function () {
            ymaps.ready(function () {
                self._renderEl();
                self.set('ready', true);

                window.m = self.ymap;
            });
        });


    },

    _renderEl: function () {
        var self = this;

        self.mapApi = ymaps;
        var center = self.get('center');

        self.ymap = new ymaps.Map(self.id, {
            center: center || [55.7526, 37.6152],
            zoom: self.get('zoom'),
            // controls: ['zoomControl', 'searchControl']
            controls: ['zoomControl']
        });

        self.pins = new ymaps.GeoObjectCollection(null, {
            preset: 'islands#blueCircleDotIconWithCaption'
        });
        self.home = new ymaps.GeoObjectCollection(null, {
            preset: 'islands#redCircleDotIconWithCaption'
        });

        /*self._createHome();
         self._createPins();*/
        self.ymap.geoObjects.add(self.pins).add(self.home);


        self.ymap.events.add('boundschange', function () {
            if (!self._handlingCenterEvent) {
                var center = self.ymap.getCenter();
                self.set('center', center);
            }
        });
    },

    makeRoute: function (from, to) {
        if (!this.mapApi) return;

        var self = this;

        self.ymap.geoObjects.remove(this.route);

        self.mapApi.route(
            [from, to],
            {routingMode: 'masstransit', multiRoute: true}
        ).done(function (route) {
            //self.mapApi.route({referencePoints:[from,to],params:{routingMode: 'masstransit'}}).then(function(route){
            self.route = route;
            self.ymap.geoObjects.add(self.route);

            // Was binded one more time in every method call
            // route.events.add('activeroutechange',self._updateMoveList);
            self._updateMoveList();
        });
    },

    _updateMoveList: function () {
        var way, segments, moveList = [],
            tempRoute = this.route.getActiveRoute();

        for (var i = 0; i < tempRoute.getPaths().getLength(); i++) {
            way = tempRoute.getPaths().get(i);
            segments = way.getSegments();
            for (var j = 0; j < segments.getLength(); j++) {
                var segment = segments.get(j);
                moveList.push(segment.properties.get('text'));
            }
        }

        this.set('moveList', moveList);
    },

    _createHome: function () {
        var homeData = this.get('home');
        //
        if (homeData && this.home) {
            this.home.add(
                new ymaps.Placemark(homeData, {iconCaption: 'You are here'})
            );
        }

    },

    _removeHome: function () {
        if (this.home)
            this.home.removeAll();
    },

    _createPins: function (pinsData) {
        var self = this;

        pinsData = pinsData || this.get('pins');
        //
        if (pinsData && this.pins) {
            for (var i = 0; i < pinsData.length; i++) {
                var p = pinsData[i];
                self.pins.add(
                    new ymaps.Placemark(p.coords, {
                        iconCaption: p.name
                    })
                );
            }
        }
    },

    _removePins: function () {
        if (this.pins)
            this.pins.removeAll();
    },

    _prop: {
        ready: {},

        zoom: {
            set: function (value) {
                if (this.ymap)
                    this.ymap.setZoom(value, {duration: 200});
                return value;
            }
        },

        pins: {
            set: function (value) {
                if (this.mapApi) {
                    this._removePins();
                    this._createPins(value);
                }
            }
        },
        home: {
            set: function (value) {
                if (this.mapApi) {
                    this._removeHome(this);
                    this._createHome(this);
                }
            }
        },
        moveList: {
            set: function () {
            }
        },

        center: {
            set: function (value) {
                if (this.mapApi) {
                    this._handlingCenterEvent = true;
                    this.ymap.setCenter(value);
                    this._handlingCenterEvent = false;
                }
            }
        },

        value: 'center'
    }
});
