var UIComponent = require('../UIComponent');

module.exports = UIComponent.extend('UI.Controls', 'ComboBox', {
    ctor: function () {
    },
    createEl: function () {

        var _self = this;
/*
 <div class="select-wrapper">
 <button class="select-trigger">utc +3</button>
 </div>
 */

        var el = this.el = UIComponent.createElementCss('div', {}, 'select-wrapper');

        this.el.draggable = false;
        var input = this.input = UIComponent.createElementCss('button', {}, 'select-trigger');
        this.el.appendChild(input);

        var controls =
            this.controls =
                UIComponent.createElementCss('div', {}, 'app-screen-controls');

        var dropDown =
            this.dropDown =
                UIComponent.createElementCss('div', {}, 'select-options-wrapper');
        controls.appendChild(dropDown);

        var title =
            this.titleEl =
                UIComponent.createElementCss('span',{},'select-options-title');
        dropDown.appendChild(title);

        var list =
            this.list =
                UIComponent.createElementCss('ul',{},'select-options');

        dropDown.appendChild(list);

        var realActive =
            this.realActive =
                UIComponent.createElementCss('ul', {
                    background: 'rgba(0,0,0,0.5)',
                    position: 'absolute',
                    top:'150px',
                    height: '150px'
                },'select-options');

        dropDown.appendChild(realActive);
        realActive.addEventListener('click', function(){
            document.body.removeChild(controls);
            _self.set('value',_self.items[_self.lastActive].key);
        });

        var activeLi = UIComponent.createElementCss('li',{},'active');
        realActive.appendChild(activeLi);


        this.lastActive = -1;
        var setActive = function(){
            var num = Math.round(list.scrollTop/150);
            if(num !== _self.lastActive){
                if(_self.lastActive>-1) {
                    list.childNodes[_self.lastActive+1].classList.remove('active');
                    list.childNodes[_self.lastActive+1].innerText = _self.items[_self.lastActive].val;
                }

                list.childNodes[num+1].classList.add('active');
                list.childNodes[num+1].innerHTML = '&nbsp;';
                activeLi.innerText = _self.items[num].val;
                _self.lastActive = num;
                list.scrollTop = num*150;
            }
        };
        input.addEventListener('click', function () {
            document.body.appendChild(controls);

            list.scrollTop = _self.lastActive*150;
        });
        setTimeout(setActive, 10);

        controls.addEventListener('wheel', function(e){
            if(e.deltaY>0)
                list.scrollTop += 150;
            else
                list.scrollTop -= 150;
            setActive();
            e.preventDefault();
            e.stopPropagation();

            //console.log(e)
        });


/*
        this.back = UIComponent.createElementCss('div', {
            background: '#ddd',
            height: height - pad * 2 + 'px',
            left: height / 2 + 'px',
            right: height / 2 + 'px',
            top: pad + 'px',
            position: 'absolute'
        });

        /*
        var mouseMoveListener = function (e) {
            _self._getInfo();
            update(e);
        };

        var update = function (e) {
            var x = e.clientX - left;
            _self.updateValuePercent((x - height / 2) / (width - height));
        };

        var width, left;

        this.el.addEventListener('mousedown', function (e, name, el) {

            _self._getInfo();
            var bound = _self.el.getBoundingClientRect();
            width = bound.width;
            left = bound.left;
            update(e);

            e.preventDefault();
            document.addEventListener('mousemove', mouseMoveListener);
        });

        document.addEventListener('mouseup', function (e, name, el) {
            document.removeEventListener('mousemove', mouseMoveListener);
        });
        */
    },
    redraw: function (val) {
        var list = this.list,
            i, arr = [];

        for(i in val){
            arr.push({key: i, val: val[i]});
        }
        arr.sort();
        this.items = arr;

        list.innerHTML = '<li class="active">&nbsp;</li>'+arr.map(function(el){
            return '<li>'+ el.val +'</li>';
        }).join('')+'<li class="active">&nbsp;</li>';
        this.itemHeight = 150; //(full-height)/(count-1)
    },
    _prop: {
        value: '_value',
        _value: {
            set: function (val, e) {

                this.input.innerText = (this.get('items')||{})[val]+'';
            }
        },
        items: {
            set: function (val, e) {
                if(typeof val === 'string'){
                    try{
                        val = (new Function('','return '+val))();
                        e.value(val);
                        this.redraw(val);
                    }catch(e){
                        console.log('Invalid JSON '+val);
                    }
                    setTimeout(function(){
                        this.set('value', this.get('value'));
                    }.bind(this),1);
                }else{
                    this.redraw(val);
                }


                //debugger;
            }
        },
        label: {
            set: function (val) {
                this.titleEl.innerText = val;
            }
        }

    }
});
