/**
 * Created by ravenor on 13.07.16.
 */

var UIComponent = require('../UIComponent');

module.exports = UIComponent.extend('UI.Controls', 'Button', {
    createEl: function () {
        var self = this;
        this.el = document.createElement('button');
        this.el.className = 'Q-UI-Button';
        this.el.setAttribute('type', 'button');

        var buttonText = document.createElement('span');
        this.el.appendChild(buttonText);
        this.el.addEventListener('click', function (event) {
            self.fire('click', event);
        });
        this.el.addEventListener('mousedown', function (event) {
            self.el.classList.add('Over');
        });
        this.el.addEventListener('mouseup', function (event) {
            self.el.classList.remove('Over');
        });

        this.buttonText = buttonText;
    },
    _tabProtocol: function (delegate) {
        if(delegate)
            return true;
        this.el.classList.add('Focused');
        this.el.focus();
    },
    _tabProtocolLeave: function(){
        this.el.classList.remove('Focused');
    },
    _prop: {
        caption: {
            set: function (val) {
                this.buttonText.innerText = (val+'').replace(/_/g, String.fromCharCode(160));
            }
        },
        direction: {
            set: function(val){
                this.removeClass(this.el,'Q-UI-Button_left');
                this.removeClass(this.el,'Q-UI-Button_right');
                
                if(val === 'left')
                    this.addClass(this.el,'Q-UI-Button_left');

                if(val === 'right')
                    this.addClass(this.el,'Q-UI-Button_right');

            }

        },
        filled: {
            set: function(val){
                this.removeClass(this.el,'Q-UI-Button_filled');
                

                if(val === true)
                    this.addClass(this.el,'Q-UI-Button_filled');

            }
        },
        value: 'caption'
    }
}, function () {
    this.set("width", "100px");
    this.set("height", "30px");
    this.set("value", "Button");
});
