var QObject = require('./QObject');

var base = QObject.prototype;

var Variant = QObject.extend('Core', 'Variant', {
    _set: function (key, value) {
        if (!this._prop[key])
            this._prop[key] = {};

        return base._set.call(this, key, value);
    }
});

Variant.deserialize = function (jsonObj) {
    if (typeof jsonObj === 'object') {
        var res = new Variant();
        for (var key in jsonObj)
            if (jsonObj.hasOwnProperty(key)) {
                res.set(key, Variant.deserialize(jsonObj[key]));
            }

        return res;
    } else {
        return jsonObj;
    }

};

module.exports = Variant;