var AbstractComponent = require('./AbstractComponent');
var cache = {},
    cssCache = {},
    style;
var Style = AbstractComponent.extend('Core', 'Style', {
    _anything: true,
    _onChildAdd: function (child) {

        child.ref('cls').subscribe(function (val, oldVal) {

        });
    },
    _propChanged: function (key, value, oldValue) {
        // OVERHACK
        var subs = this.__refs[key];
        if (subs)
            for (var i = 0; i < subs.length; i++) {
                subs[i].resolve(value, oldValue);
            }

        var cls = cache[key] || (cache[key] = this.getBaseCls(key));
        if(!cssCache[cls])
            cssCache[cls] = {};

        this.setCss(cls, cssCache[cls], value);
    },
    addRule: function (cls, style) {
        var id, rule;
        if(!(style.sheet||{}).insertRule) {
            id = (style.styleSheet || style.sheet).addRule(cls, '');
        }else {
            id = style.sheet.insertRule(cls + "{}");
        }
        return (style.styleSheet || style.sheet).rules[id];
    },
    setCss: function (baseCls, store, val) {
        var cls;
        if(val.cls && val.cls !== '.'){
            cls = val.cls
                .split('.')
                .filter(String)
                .concat(baseCls)
                .map(function(el){return '.'+el;})
                .join('');

        }else{
            cls = '.'+baseCls;
        }
        var ss = cssCache[cls] = cssCache[cls] || {};
        if(!style) {
            style = document.createElement('style');
            style.type = 'text/css';
            document.getElementsByTagName('head')[0].appendChild(style);

        }
        !ss.rule && (ss.rule = this.addRule(cls, style));
        var rule = ss.rule;
        for(var i in val){
            if(i!=='cls' && store[i] !== val[i]){
                store[i] = rule.style[i] = val[i];
            }
        }
    },
    getBaseCls: function (key) {
        var cls = Q.Core.TypeTable.search(key);
        if(!cls)
            throw new Error ('Unknown cls `'+key+'`');
        return 'Q-UI-'+cls[0].ctor.type;
    }
});

var UIComponent = require('../UI/UIComponent');
var Style2 = UIComponent.extend('Core', 'Style2', {
    //_anything: true,
    _onChildAdd: function (child) {
        debugger;
    }
});