var QObject;

function Reference(obj, key, callback) {

    if (!QObject)
        QObject = require("./QObject");

    this.obj = obj;
    this.callback = callback;

    var names = key;
    this.key = key;

    this.path = key;

    if (names.length > 1) {
        this.type = 'chain';
        this.createNextRef();
    } else {
        names[0] = obj.__checkValue(names[0]);
    }

    return this;
}

Reference.prototype =
    {
        oldVal: void 0,
        destroyNext: function () {
            if (this._nextRef) {
                var index = this._nextRef.obj.__refs[this._nextRef.path[0]].indexOf(this._nextRef);

                if (index >= 0)
                    this._nextRef.obj.__refs[this._nextRef.path[0]].splice(index, 1);

                this._nextRef.destroyNext();
                this._nextRef.callback = void(0);
                delete this._nextRef;
            }
        },
        createNextRef: function () {
            var self = this;
            var names = this.path;
            var obj = this.obj;

            var nextName = names[0];
            nextName = obj.__checkValue(nextName);

            var nextObj = obj.get(nextName);
            if (nextObj && nextObj instanceof QObject) {
                var nextRef = nextObj.ref(names.slice(1));
                nextRef.oldVal = nextObj.get(names.slice(1), true);

                nextRef._uberRef = this;
                nextRef._mainRef = this._mainRef || this;
                nextRef.type = 'chain';
                self._nextRef = nextRef;
                nextRef.subscribe(function (val, oldVal) {
                    self.destroyNext();
                    self.createNextRef();
                    self.resolve(val, oldVal);
                });
            }
        },
        get: function () {
            return this.obj.get(this.key, true);
        },
        getOld: function (val, key) {
            if(!val)
                return val;
            if(val instanceof QObject)
                return val.get(this.key, true);
            else {
                var result = val;
                for(var i = 0, _i = this.key.length; i < _i; i++){
                    if(!result)
                        break;

                    if(result instanceof QObject)
                        result = result.get([this.key[i]], true);
                    else
                        result = result[this.key[i]];
                }
                return result;
            }
        },
        set: function (value) {
            this.obj.set(this.key, value);
        },
        subscribe: function (callback) {
            this.callback = callback;
        },
        resolve: function (val, oldVal, key) {
            var cb = this.callback;
            if (this.type === "chain") {
                val = this.get();
                var goldVal = this.getOld(oldVal, key);

                var ref = this._uberRef || this;
                cb = ref.callback;
            }
            //console.log('CHANGE', this.key.join('.'), val, oldVal, this.oldVal, goldVal);

            if (cb && val !== this.oldVal) {
                this.oldVal = val;
                cb(val, oldVal);
            }

        }
    };

module.exports = Reference;
