var observable = require('z-observable');
var TypeTable = require('./TypeTable');
var Pipe = require('./Pipe');
var Reference = require('./Reference');
var index = 0;
function QObject() {
    this._data = {};
    this.__subscribers = {};
    this.__refs = {};
    observable.prototype._init.apply(this);
    this.____id = this.__proto__.type + (index++) + '_' + this.createRandomString(12);
}

var prototype = {
    on: observable.prototype.on,
    once: observable.prototype.once,
    fire: observable.prototype.fire,
    removableOn: observable.prototype.removableOn,
    un: observable.prototype.un,

    __checkValue: function (key) {
        if (!key || key === 'value') {
            if (this._prop.value)
                return this._prop.value;
            else
                return null;
        } else {
            return key;
        }
    },
    createRandomString: function (length) {
        length = length || 12;
        var text = "";
        var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        for (var i = 0; i < length; i++)
            text += possible.charAt(Math.floor(Math.random() * possible.length));
        return text;
    },
    serialize: function () {
        var data = this._data;
        var result = {};

        for (var key in data)
            if (data.hasOwnProperty(key)) {
                if (data[key] instanceof QObject)
                    result[key] = data[key].serialize();
                else
                    result[key] = data[key];
            }

        return result;
    },

    get: function (names, soft, returnLastQObject) {
        if (!Array.isArray(names)) {
            names = names.split('.');
        }

        if (!names || names.length <= 0) {
            return this._get('value');
        }

        var ret = this;
        var lastQObject = ret;

        for (var i = 0; i < names.length; i++) {
            if (ret instanceof QObject) {
                ret = ret._get(names[i]);
                lastQObject = ret;
            } else {
                ret = ret[names[i]];
            }

            if (!ret && i < names.length - 1) {
                if (soft)
                    return void(0);
                else
                    throw new Error('NullReferenceException: try get `' + names.join('.') + '` and `' + names[i] + '` is undefined');
            }
        }

        if (returnLastQObject)
            return {lastQObject: lastQObject, result: ret};

        return ret;

    },
    _get: function (key) {
        key = this.__checkValue(key);
        if (!key) return null;

        var ret = void(0);
        var property = this._prop[key];

        if (property) {
            var getter = property.get;
            if ("get" in property) {
                if (getter)
                    ret = getter.call(this);
                else
                    throw new Error("Property '" + key + "' hes no getter");
            }
            else
                ret = this._data[key];

        } else {
            ret = this._data[key];
        }

        return ret
    },

    /**
     *
     * @param names
     * @param value
     * @returns {*}
     */
    set: function (names, value) {

        names = names.slice(0);

        if (value instanceof Pipe) {
            value.to(this.ref(names));
            return;
        }

        if (!Array.isArray(names)) {
            names = names.split('.');
        }

        if (!names || names.length <= 0) {
            return this._set('value', value);
        }

        if (names.length === 1) {
            return this._set(names[0], value);
        }

        var objToSetFor = this.get(names[0]);

        if (objToSetFor instanceof QObject) {
            var setted = objToSetFor.set(names.slice(1), value);
            //objToSetFor.set(names.slice(1), value);
        } else {
            var origin = names[0];
            names = names.slice(1);
            var nextObj = objToSetFor;
            while (!(objToSetFor instanceof QObject) && names.length > 1 && objToSetFor) {
                objToSetFor = objToSetFor[names[0]];
                names = names.slice(1);
            }
            if (objToSetFor instanceof QObject)
                objToSetFor.set(names.slice(1), value);
            else if (objToSetFor) {
                var oldVal = objToSetFor[names[0]];
                objToSetFor[names[0]] = value;
                this._propChanged(origin, nextObj);
            }
        }

        //this._propChanged(names[0]);
        return this;
    },

    /**
     *
     * @param key
     * @param value
     * @returns {*}
     * @private
     */
    _set: function (key, value) {
        var _data = this._data;

        key = this.__checkValue(key);
        if (!key) return null;

        var oldValue = this._data[key];

        var flags = {
            oldValue: oldValue,
            value: function (newVal) {
                flags.useNew = true;
                flags.newVal = newVal;
                _data[key] = newVal;
            }
        };

        var property = this._prop[key];
        if (property) {
            var setter = property.set;
            if ("set" in property) {
                if (setter)
                    setter.call(this, value, flags);
                else
                    throw new Error("Property '" + key + "' has no setter");
            }
        }

        var newVal = flags.useNew ? flags.newVal : value;



        if (newVal !== oldValue) {

            _data[key] = newVal;
            this._propChanged(key, newVal, oldValue);
        }
        return this;
    },
    call: function (fname) {
        var method = this._method[fname];
        if (!method) {
            throw new Error(this.type + ' has no method ' + fname);
        }

        var args = Array.prototype.slice.call(arguments, 1);

        method.apply(this, args);
    },
    _propChanged: function (key, value, oldValue) {
        //var subs = this.__subscribers[key];
        var subs = this.__refs[key];
        if (subs) {
            for (var i = 0; i < subs.length; i++) {
                subs[i].resolve(value, oldValue, key);
            }
        }
    },
    ref: function (key) {
        var self = this;
        key = key || 'value';
        if (!Array.isArray(key)) {
            key = key.split('.');
        }

        var ref = new Reference(this, key);

        var refs = this.__refs;
        if (!refs[key[0]]) {
            refs[key[0]] = [];
        }
        refs[key[0]].push(ref);


        return ref;
    },
    setAll: function (values) {
        for (var key in values)
            if (values.hasOwnProperty(key)) {
                this.set(key, values[key]);
            }
        return this;
    },
    _prop: {
        value: '_value',
        _value: {}
    },
    _method: {}
};
QObject.prototype = prototype;

QObject.type = "QObject";
QObject.namespace = "Core";

QObject.fixKey = function (key) {
    if (!Array.isArray(key)) {
        key = key.split('.');
    }
    return key;
};

QObject.joinKey = function () {

    var arrayProt = Array.prototype;

    var args = arguments;

    args = arrayProt.map.call(args, function(arg){
        return QObject.fixKey(arg);
    });

    return arrayProt.concat.apply([], args);
};

QObject.extend = function (namespace, newName, proto, ctor) {

    proto = proto || {};

    if (proto.ctor && ctor)
        throw new Error('Constructor duplication');

    // Default constructor
    ctor = proto.ctor || ctor || function () {
        };

    proto._prop = proto._prop || {};
    proto._method = proto._method || {};

    var parentConstructor = TypeTable.getType(this.namespace, this.type);
    var parentPrototype = Object.create(parentConstructor.prototype);

    proto.__proto__ = parentPrototype;

    // Force parent constructor call
    var newCtor = function (cfg) {
        parentConstructor.apply(this);
        var me = ctor.call(this);
        if (me)
            return me;
        if (cfg)
            this.setAll(cfg);
    };

    Object.defineProperty(newCtor, "name", {value: newName});

    // "Merge" props
    proto._prop.__proto__ = parentConstructor.prototype._prop;
    proto._method.__proto__ = parentConstructor.prototype._method;
    proto.type = newName;
    proto.namespace = namespace;
    newCtor.parent = parentConstructor;

    // Make new class
    newCtor.prototype = proto;
    newCtor.extend = this.extend;

    newCtor.namespace = namespace;
    newCtor.type = newName;

    TypeTable.registerType(namespace, newName, newCtor);

    return newCtor;
};

TypeTable.registerType("Core", "QObject", QObject);

module.exports = QObject;