var TypeTable = require('./TypeTable');

/**
 *
 * @constructor
 */
function Pipe() {
    this.toRef = void(0);
    this.fn = arguments[arguments.length - 1];

    var argumentsLength = arguments.length - 1;

    if (arguments.length === 1) {
        argumentsLength += 1;
        this.fn = function (a) {
            return a;
        }
    }

    this.inputCache = [];
    this.outputCache = void(0);

    for (var i = 0; i < argumentsLength; i++) {
        var ref = arguments[i];
        this.inputCache[i] = ref.get();
        this._subscribeToLink(ref, i);
    }

    var result = this.fn.apply(this, this.inputCache);
    this.outputCache = result;
}

/**
 *
 * @type {{to: Pipe.to, _subscribeToLink: Pipe._subscribeToLink}}
 */
Pipe.prototype = {
    to: function (toRef) {
        this.toRef = toRef;
        this.toRef.set(this.outputCache);
    },
    _subscribeToLink: function (ref, index) {
        var self = this;
        ref.subscribe(function (val, oldVal) {
            self.inputCache[index] = val;
            var result = self.fn.apply(this, self.inputCache);
            self.outputCache = result;

            if (self.toRef)
                self.toRef.set(result);
        });
    }
};
/*
Pipe.done = function(){

};
Pipe.done.prototype = new Pipe();
*/

TypeTable.registerType('Core', 'Pipe', Pipe);
module.exports = Pipe;