var RunAtServerComponent = require('./RunAtServerComponent');
var QObject = require('./QObject');
var Pipe = require('./Pipe');
var Variant = require('./Variant');

var base = RunAtServerComponent.prototype;

var QData = {};

var config = require('../../platform/config');

config.load(function(data){
    var parsedData;
    try {
        parsedData = JSON.parse(data);
    }
    catch (e) {
        console.log(e);
        throw e;
    }
    QData = Variant.deserialize(parsedData);
    QData._regherughelrgd = true;
});

var Config = RunAtServerComponent.extend('Core', 'Config', {
    ctor: function () {
        this._data['qData'] = QData;
    },
    save: function () {
        config.save(JSON.stringify(QData.serialize(), null, '\t'));
    },
    set: function (key, value) {
        key = key.indexOf('qData') === -1 ? QObject.joinKey('qData', key) : key;
        var ret = base.set.call(this, key, value);

        this.save();
        return ret;
        //QData.set(key, value);
    },
    get: function (key) {
        key = key.indexOf('qData') === -1 ? QObject.joinKey('qData', key) : key;

        return base.get.call(this, key, true);
        //QData.get(key);
    },
    ref: function (key) {
        key = key.indexOf('qData') === -1 ? QObject.joinKey('qData', key) : key;

        var ret = base.ref.call(this, key);
        return ret;
        //return QData.ref(key);
    },
    prop: {
        qData: {}
    }
});

module.exports = Config;