/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 * *
 */
;// QUOKKA 2017
// By zibx on 5/18/17.

var QObject = require('./QObject');
var Time = function(val){
    var may = new Date(val),
        isValid = !isNaN(may.getDate());
    if(isValid){
        may = new Date(may-may.getTimezoneOffset()*60*1000);
        this.hours = may.getHours();
        this.minutes = may.getMinutes();
        this.seconds = may.getSeconds();
    }else if(typeof val === 'string'){
        var tokens = val.split(':');

        this.hours = tokens[0]|0;
        if(tokens.length > 1) {
            this.minutes = tokens[1] | 0;
        }
        if(tokens.length > 2) {
            this.seconds = tokens[2] | 0;
        }
    }else if(val !== void 0){
        this.valid = false;
    }
};
Time.prototype = {
    hours: 0,
    minutes: 0,
    seconds: 0,
    valid: true,
    le: function(){
        
    },
    ge: function(){
        
    },
    getSeconds: function(){
        return this.seconds + this.minutes * 60 + this.hours * 60 * 60;
    }
};

/** @class */
var Commission = QObject.extend('Core', 'Commission', {
    ctor: function () {

    },
    calc: function (cfg) {
        !('rules' in cfg) && (cfg.rules = this.get('rules'));
        !('amount' in cfg) && (cfg.amount = this.get('amount'));
        !('up' in cfg) && (cfg.up = this.get('up'));
        !('date' in cfg) && (cfg.date = this.get('date'));
        if(!cfg.date){
            cfg.date = new Date();
            cfg.date = new Date((+cfg.date)-cfg.date.getTimezoneOffset()*60*1000);
        }else{
            cfg.date = new Date(cfg.date);
            cfg.date = new Date((+cfg.date)+cfg.date.getTimezoneOffset()*60*1000);
        }
        if(cfg.rules && cfg.amount){
            var matched = cfg.rules.filter(function(rule){
                var fromTime, toTime, fromDate, toDate;
                if('fromTime' in rule){
                    fromTime = new Time(rule.fromTime);
                    if('toTime' in rule){
                        toTime = new Time(rule.toTime);
                    }else{
                        toTime = new Time('23:59:59');
                    }
                }else if('toTime' in rule){
                    fromTime = new Time();
                    toTime = new Time(rule.toTime);
                }
                if(
                    fromTime && fromTime.valid &&
                    toTime && toTime.valid
                ){
                    var date = cfg.date;
                    var dateSeconds = date.getSeconds() + date.getMinutes() * 60 + date.getHours() * 60 * 60;
                    if(fromTime.getSeconds() < toTime.getSeconds()){
                        if(
                            fromTime.getSeconds() <= dateSeconds &&
                            toTime.getSeconds() >= dateSeconds
                        )
                            return true;
                    }else{
                        if(
                            toTime.getSeconds() >= dateSeconds ||
                            fromTime.getSeconds() <= dateSeconds
                        )
                            return true;
                    }
                    return false;
                }
                return true;
            });
            if(matched.length){
                var rule = matched[0],
                    result = {};

                if(cfg.up){
                    result.commission = cfg.amount*rule.percent/100;

                    if(rule.min) {
                        if(result.commission < rule.min){
                            console.log('Percent is smaller than min commission ('+[result.commission, rule.min]+')')
                            result.commission = rule.min;
                        }
                    }

                    if(rule.max){
                        if(result.commission > rule.max){
                            console.log('Percent is greater than max commission ('+[result.commission, rule.max]+')')
                            result.commission = rule.max;
                        }
                    }

                    result.full = (result.commission + cfg.amount).toFixed(2);
                    result.commission = result.commission.toFixed(2);
                    result.amount = cfg.amount.toFixed(2);
                }else{
                    result.commission = cfg.amount/100*rule.percent;

                    if(rule.min) {
                        if(result.commission < rule.min){
                            console.log('Percent is smaller than min commission ('+[result.commission, rule.min]+')')
                            result.commission = rule.min;
                        }
                    }

                    if(rule.max){
                        if(result.commission > rule.max){
                            console.log('Percent is greater than max commission ('+[result.commission, rule.max]+')')
                            result.commission = rule.max;
                        }
                    }


                    result.full = (cfg.amount).toFixed(2);
                    result.amount = (cfg.amount-result.commission).toFixed(2);
                    result.commission = result.commission.toFixed(2);
                }
                this.set('result', result);
                console.log(result)
            }

        }
    },
    _prop: {
        date: {
            set: function(val){
                this.calc({date: val});
            }
        },
        rules: {
            set: function(val){
                this.calc({rules: val});
            }
        },
        amount: {
            set: function(val, e){
                val = parseFloat(val);
                e.value(val);
                this.calc({amount: val});
            }
        },
        result: {},
        up: {
            set: function(val){
                this.calc({up: val});
            }
        }
    }
});
/*var c = new Commission();
c.set('rules', [
    {
        fromTime: '10:00',
        toTime: '20:00',
        //fromDate: new Date(2017,0,1),
        //toDate: new Date(2017,1,1),
        min: 10,
        max: 20,
        percent: 3
    },
    {
        fromTime: '20:00',
        toTime: '10:00',
        //fromDate: new Date(2017,0,1),
        //toDate: new Date(2017,1,1),
        min: 10,
        max: 20,
        percent: 4
    },
    {
        toTime: '20:00',//new Date(2017,1,1,20),
        //fromDate: new Date(2017,0,1),
        //toDate: new Date(2017,1,1),
        min: 10,
        max: 20,
        percent: 3
    },{
        fromTime: '10:00',
        //fromDate: new Date(2017,0,1),
        //toDate: new Date(2017,1,1),
        min: 10,
        max: 20,
        percent: 3
    },{
        /!*fromDate: new Date(2017,0,1),
        toDate: new Date(2017,1,1),*!/
        min: 10,
        max: 20,
        percent: 3
    },{
        fromTime: '2017-01-02T12:10:33Z',
        /!*fromDate: new Date(2017,0,1),
        toDate: new Date(2017,1,1),*!/
        min: 10,
        max: 20,
        percent: 3
    }
]);
c.set('date', new Date(2017,1,2,15,22))
c.set('amount',15)
c.set('amount',35)
c.set('amount',100)
c.set('amount',200)
c.set('amount',400)
c.set('amount',500)
c.set('amount',1000)
console.log('---')
c.set('date', new Date(2017,1,2, 9,22))
c.set('amount',15)
c.set('amount',35)
c.set('amount',100)
c.set('amount',200)
c.set('amount',400)
c.set('amount',500)
c.set('amount',1000)*/

module.exports = Commission;