module.exports =
    QRequire('Core.QObject', 'Core.AbstractComponent', function(
        QObject,
        AbstractComponent
    ) {
        'use strict';

        var base = AbstractComponent.prototype;
        var trim = function (text) {
            return text.trim();
        };
        var UIComponent = AbstractComponent.extend('UI', 'UIComponent', {
            ctor: function () {
                this.createEl();
                this.setAll({
                    "pureCss": "position: relative; overflow: visible;",
                    width: '100%',
                    height: '100%'
                });
                this._contentContainer = void(0);
                this.baseCls = "Q-UI-" + this.type;
                this.el.classList.add(this.baseCls);
                var _self = this;

                this.on('drawed', function () {
                    _self._getAllChildren(UIComponent).forEach(function (item) {
                        item.fire('drawed');
                    });
                });

                this.on('__shadowProtocol', this.__shadowProtocol);
            },
            getVieport: function () {
                return document.getElementById('viewport');
            },
            removeClass: function (el, name) {
                el.className = ((' ' + el.className + ' ').replace(' ' + name + ' ', ' ')).trim();
            },
            addClass: function (el, name) {
                !this.hasClass(el, name) && (el.className += ' ' + name);
            },
            hasClass: function (el, name) {
                return (' ' + el.className + ' ').indexOf(' ' + name + ' ') > -1;
            },

            /**
             *
             */
            updateLayout: function () {
                this._getAllChildren(UIComponent).forEach(function (item) {
                    item.updateLayout();
                });
            },

            /**
             * @override
             */
            _onChildAdd: function (child, prev, next) {
                base._onChildAdd.call(this, child);

                var insertInto;

                if (this._contentContainer) {
                    insertInto = this._contentContainer.el;
                } else {
                    insertInto = this.el;
                }

                //insert to DOM or _contentContainer
                if (child.el) {
                    if (!next) {
                        insertInto.appendChild(child.el);
                    } else {
                        insertInto.insertBefore(child.el, next.el);
                    }
                    child.renderTo = insertInto;
                    child.fire('addToParent');
                }

                if (child instanceof UIComponent)
                    child.updateLayout();
            },

            _onChildRemove: function (child) {
                child.parent = null;
                var removeFrom;

                if (this._contentContainer) {
                    removeFrom = this._contentContainer.el;
                } else {
                    removeFrom = this.el;
                }

                removeFrom.removeChild(child.el);
            },

            /**
             * @override
             */
            _onOwnComponentAdd: function (child) {
                base._onOwnComponentAdd.call(this, child);

                if (child instanceof TypeTable.getType('UI', 'ContentContainer')) {
                    this._contentContainer = child;
                }
                // Add to DOM
                if (child.el) {
                    child.renderTo = this.el;
                    this.el.appendChild(child.el);
                    child.fire('addToParent');
                }
            },

            /**
             *
             */
            createEl: function () {
                var self = this;
                if (!this.el) {
                    this.el = document.createElement('div');
                    this.el.style.overflow = 'hidden';
                    this.el.style.position = 'relative';
                }
                this.el.addEventListener('click', function () {
                    self.fire('click');
                });
            },

            _method: {
                red: function () {
                    var self = this;
                    self.set("pureCss", "background:red");
                }
            },

            __getShadowDelegate: function (what) {
                var _self = this;
                return this.sd || (this.sd =
                        {
                            what: what,
                            activate: function (me) {
                                _self.__shadowProtocol(what, me);
                            },
                            deactivate: function (me) {
                                me = me || _self.sd.getLast();
                                me && _self.__shadowProtocol(what, me, true);
                            },
                            next: function (me) {
                                this.what.direction = 'next';
                                _self.__shadowProtocol(this.what);
                            },
                            prev: function (me) {
                                this.what.direction = 'prev';
                                _self.__shadowProtocol(this.what);
                            },
                            skip: function () {
                                _self.__shadowProtocol(this.what);
                            },
                            send: function () {
                                var last = _self['_' + what.type + 'ProtocolLast'];
                                if (!last) {
                                    document.activeElement.click();
                                    last = _self['_' + what.type + 'ProtocolLast'];
                                }
                                if (last && last.match) {
                                    var fn = last.match['_' + what.type + 'ProtocolReceive'];
                                    if (fn)
                                        fn.apply(last.match, arguments);
                                }
                            },
                            collect: function (what) {
                                _self.___shadowProtocol(what, this);
                            },
                            getLast: function () {
                                return _self[what.method + 'Last'];
                            },
                            setLast: function (val) {
                                return _self[what.method + 'Last'] = val;
                            }
                        });
            },
            __shadowProtocol: function (what, actor, loose) {
                var whot = Object.create(what);
                whot.chain = [];
                whot.match = void 0;
                var i, _i, chain, lastChain, who,
                    _self = this,
                    delegate = this.__getShadowDelegate(whot);
                what.delegate = delegate;
                what.chain = [];
                what.initiator = this;
                what.method = '_' + what.type + 'Protocol';

                if (!('direction' in what)) {
                    what.direction = 'next';
                }

                delegate.collect(what);
                //this.___shadowProtocol(what, delegate);
                chain = what.chain;
                if (!chain.length)
                    return what;

                lastChain = delegate.getLast();//this[what.method+'Last'];
                if (actor) {
                    who = actor;
                } else {
                    _i = chain.length;
                    if (what.direction === 'next') {
                        for (i = 0; i < _i; i++) {
                            if (!lastChain) {
                                who = chain[i];
                                break;
                            } else {
                                if (lastChain.match === chain[i]) {
                                    who = chain[(i + 1) % _i];
                                    break;
                                }
                            }
                        }
                    } else {
                        for (i = _i - 1; i >= 0; i--) {
                            if (!lastChain) {
                                who = chain[i];
                                break;
                            } else {
                                if (lastChain.match === chain[i]) {
                                    who = chain[(i - 1 + _i) % _i];
                                    break;
                                }
                            }
                        }
                    }
                }
                if (lastChain !== who) {
                    // if component give it's permissions to leave
                    if (
                        what.force || !lastChain || !lastChain.match[what.method + 'Leave'] ||
                        lastChain.match[what.method + 'Leave']() !== false
                    ) {
                        if (!loose) {
                            what.match = who;
                            delegate.setLast(what);

                            who[what.method]();
                        }
                    }
                }
                return what;
            },
            ___shadowProtocol: function (what, delegate) {
                var method = what.method,
                    children, i, _i, child;

                if (typeof this[method] === 'function' && this[method](delegate)) {
                    what.chain = what.chain.concat(this);
                }

                children = this._getAllChildren(UIComponent);
                for (i = 0, _i = children.length; i < _i; i++) {
                    child = children[i];
                    child.___shadowProtocol(what, delegate);
                }
                return what;
            },
            _shadowProtocol: function (protocol) {
                var name = '_' + protocol + 'ProtocolLast';
                if (!this[name])
                    return false;

                return this[name].match;
            },


            /**
             *
             */
            _prop: {
                cls: {
                    set: function (val, e) {
                        var el = this._contentContainer ? this._contentContainer.el : this.el;
                        e.oldValue && e.oldValue
                            .split('.')
                            .map(trim)
                            .filter(String)
                            .forEach(function (name) {
                                el.classList.remove(name);
                            });

                        val && val
                            .split('.')
                            .map(trim)
                            .filter(String)
                            .forEach(function (name) {
                                el.classList.add(name);
                            });
                    },
                    get: function () {
                        return ([this.baseCls].concat(
                            (this._data.cls || '')
                                .split('.')
                                .map(trim)
                                .filter(String))
                            .map(function (el) {
                                return '.' + el;
                            }).join(''))
                    }
                },
                fontSize: {
                    set: function (value) {
                        var el = this._contentContainer ? this._contentContainer.el : this.el;
                        el.style.fontSize = value;
                    }
                },
                padding: {
                    set: function (value) {
                        var el = this._contentContainer ? this._contentContainer.el : this.el;
                        el.style.padding = value;
                    }
                },
                margin: {
                    set: function (value) {
                        var el = this._contentContainer ? this._contentContainer.el : this.el;
                        el.style.margin = value;
                    }
                },
                scroll: {
                    set: function (value) {
                        if (this._contentContainer)
                            this._contentContainer.set('scroll', value);

                        switch (value) {
                            case 'horizontal':
                                this.el.style.overflowX = 'auto';
                                this.el.style.overflowY = 'visible';
                                break;
                            case 'vertical':
                                this.el.style.overflowX = 'visible';
                                this.el.style.overflowY = 'auto';
                                break;
                            case 'both':
                                this.el.style.overflowX = 'auto';
                                this.el.style.overflowY = 'auto';
                                break;
                            default:
                                this.el.style.overflow = 'visible';
                                break;
                        }
                    }
                },
                height: {
                    set: function (height) {
                        height = '' + height || 'auto';
                        this.el.style.height = height.trim();
                    }
                },
                width: {
                    set: function (width) {
                        width = '' + width || 'auto';
                        this.el.style.width = width.trim();
                    }
                },
                left: {
                    set: function (left) {
                        left = '' + left || 'auto';
                        this.el.style.left = left.trim();
                    }
                },
                right: {
                    set: function (right) {
                        right = '' + right || 'auto';
                        this.el.style.right = right.trim();
                    }
                },
                top: {
                    set: function (top) {
                        top = '' + top || 'auto';
                        this.el.style.top = top.trim();
                    }
                },
                bottom: {
                    set: function (bottom) {
                        bottom = '' + bottom || 'auto';
                        this.el.style.bottom = bottom.trim();
                    }
                },
                background: {
                    set: function (value) {
                        this.el.style.background = value;
                    }
                },
                color: {
                    set: function (value) {
                        this.el.style.color = value;
                    }
                },
                position: {
                    set: function (value) {
                        this.el.style.position = value;
                    }
                },
                pureCss: {
                    set: function (value) {
                        var rules = value.split(';');
                        for (var i = 0; i < rules.length; i++) {
                            var rule = rules[i];
                            var parts = rule.split(':');
                            this.el.style[parts[0].trim()] = parts[1];
                        }
                    }
                },
                visibility: {
                    set: function (val) {
                        switch (val) {
                            case 'visible':
                                this.el.style.display = '';
                                this.el.style.opacity = 1;
                                break;
                            case 'flex':
                                this.el.style.display = 'flex';
                                this.el.style.opacity = 1;
                                break;
                            case 'hidden':
                                this.el.style.display = '';
                                this.el.style.opacity = 0;
                                break;
                            case 'collapsed':
                                this.el.style.display = 'none';
                                break;
                        }
                    }
                },

            }
        });

        UIComponent.createElementCss = function (name, css, className) {
            var el = document.createElement(name);

            if (className)
                el.className = className;

            for (var key in css)
                if (css.hasOwnProperty(key)) {
                    el.style[key] = css[key];
                }
            return el;
        };

        return UIComponent;
    });
