/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 * *
 */
;// QUOKKA 2017
// By zibx on 5/22/17.
module.exports = 
QRequire('UI.UIComponent', 'Core.QObject', function(
    UIComponent,
    QObject
) {
    'use strict';

    var svgNS = 'http://www.w3.org/2000/svg';

    return UIComponent.extend('UI.Controls', 'SVG', {
        ctor: function () {
            var self = this;

            var buttonSVG = this.svg = document.createElementNS(svgNS, 'svg');
            buttonSVG.setAttributeNS(null, 'width', '100%');
            buttonSVG.setAttributeNS(null, 'height', '100%');
            buttonSVG.setAttributeNS(null, 'stroke', '#f00');
            buttonSVG.setAttributeNS(null, 'fill', 'none');


            this.el.appendChild(buttonSVG);

            var buttonText = this.buttonText = document.createElement('span');
            this.el.appendChild(buttonText);
            this.el.addEventListener('click', function (event) {
                self.fire('click', event);
            });
            var _private = new QObject({added: false});
            this.on('drawed', function () {
                _private.set(['added'], true);
            });
            new Pipe(
                this.ref('viewBox'),
                this.ref('path'),
                _private.ref('added'),
                this.recalculate.bind(this)
            );
            this.pathsCache = {}
        },
        recalculate: function (vb, paths, added) {
            if (vb && paths && added) {
                !Array.isArray(paths) && (paths = [paths]);
                var cache = this.pathsCache;
                var used = {},
                    svg = this.svg;
                var size = [this.get('width'), this.get('height')],
                    clientSize = {
                        dx: this.el.clientWidth,
                        dy: this.el.clientHeight
                    },
                    vbs = vb.split(' ').map(Number);
                vbs = {left: vbs[0], top: vbs[1], right: vbs[2], bottom: vbs[3], dx: 0, dy: 0};
                vbs.dx = vbs.right - vbs.left;
                vbs.dy = vbs.bottom - vbs.top;

                paths.forEach(function (path) {
                    var s = false;
                    path = path.replace(/([0-9]+(\.[0-9]+)?)/g, function (a, val) {
                        s = !s;
                        return (val - vbs[s ? 'left' : 'top']) / vbs[s ? 'dx' : 'dy'] * clientSize[s ? 'dx' : 'dy'];
                    });
                    if (!(path in cache)) {
                        var p = cache[path] = document.createElementNS(svgNS, 'path');
                        p.setAttributeNS(null, 'd', path);
                        svg.appendChild(p);
                    }
                    used[path] = true;

                });
                for (var i in cache) {
                    if (!(i in used)) {
                        svg.removeChild(cache[i]);
                        delete cache[i];
                    }
                }

                //debugger;
            }
        },
        _prop: {
            value: 'caption',
            caption: {
                set: function (val) {
                    this.buttonText.innerText = (val + '').replace(/_/g, String.fromCharCode(160));
                }
            },
            viewBox: {},
            path: {}
        }
    });

});