/**
 * Created by zibx on 5/6/17.
 */
module.exports =
    QRequire('UI.UIComponent', function(
        UIComponent
    ) {
        'use strict';

        return ('button,canvas,center,div,' +
        'h1,h2,h3,h4,h5,h6,' +
        'li,ol,span,sub,sup,' +
        'table,tbody,td,th,thead,tr,marquee')
            .split(',')
            .map(function (name) {
                return UIComponent.extend('UI.HTML', name, {
                    ctor: function () {
                        this.el = document.createElement(name);
                        this.el.classList.add(this.baseCls);
                    },
                    _prop: {
                        value: 'text',
                        text: {
                            set: function (val) {
                                if (!this.textNode) {
                                    this.textNode = document.createTextNode('');
                                    this.el.appendChild(this.textNode);
                                }
                                this.textNode.nodeValue = val;

                            }
                        },
                        html: {
                            set: function (val) {
                                this.el.innerHTML = val;
                            }
                        }
                    }
                });

            });

    });