module.exports =
QRequire('Core.RunAtServerComponent','Core.QObject', 'Core.Variant', function(
    RunAtServerComponent,
    QObject,
    Variant
) {
    'use strict';

    var base = RunAtServerComponent.prototype;

    var Config = RunAtServerComponent.extend('Core', 'Config', {
        ctor: function () {
        },
        load: function () {
            var config = require(this.get('path'));

            config.load(function (data) {
                var parsedData;
                try {
                    parsedData = JSON.parse(data);
                    this._data['qData'] = Variant.deserialize(parsedData);
                }
                catch (e) {
                    console.log(e);
                    throw e;
                }

            });
        },
        save: function () {
            config.save(JSON.stringify(QData.serialize(), null, '\t'));
        },
        set: function (key, value) {
            key = key.indexOf('qData') === -1 ? QObject.joinKey('qData', key) : key;
            var ret = base.set.call(this, key, value);

            this.save();
            return ret;
            //QData.set(key, value);
        },
        get: function (key) {
            key = key.indexOf('qData') === -1 ? QObject.joinKey('qData', key) : key;

            return base.get.call(this, key, true);
            //QData.get(key);
        },
        ref: function (key) {
            key = key.indexOf('qData') === -1 ? QObject.joinKey('qData', key) : key;

            var ret = base.ref.call(this, key);
            return ret;
            //return QData.ref(key);
        },
        prop: {
            value: 'path',
            path: {
                set: function (val, e) {
                    e.value(val);
                    this.load();
                }
            },
            qData: {}
        }
    });
    return Config;
});
