module.exports =
    QRequire('UI.UIComponent', 'UI.Border', function(
        UIComponent,
        Border
    ) {
        'use strict';


        var propNames = ['width', 'height', 'top', 'left'];

        var base = Border.prototype;

        return Border.extend('UI.Controls', 'Grid', {
            ctor: function () {
                this._cache = {};
                this.setAll({
                    rows: 1,
                    columns: 1
                });
            },
            createEl: function () {
                base.createEl.apply(this, arguments);
                var self = this;
                this.el.addEventListener('resize', function () {
                    self.updateLayout();
                });
            },
            addChild: function (child) {
                var self = this;
                this._calcChild(child);

                for (var i = 0; i < propNames.length; i++) {
                    var pName = propNames[i];
                    (function (name) {
                        child.ref(pName).subscribe(function (value) {
                            if (propNames.indexOf(name) === -1) return;

                            if (self._cache[child.id + name] !== value) {
                                self._calcChild(child);
                            }
                        });
                    })(pName);
                }

                base.addChild.call(this, child);
            },
            _calcChild: function (cmp) {
                var rows = this._data.rows;
                var cols = this._data.columns;

                var width = cmp.get('width');
                var height = cmp.get('height');
                var top = cmp.get('top') || 0;
                var left = cmp.get('left') || 0;

                cmp.el.style.position = 'absolute';
                this._setToComponent(cmp, 'left', ((100 / cols) * left) + '%');
                this._setToComponent(cmp, 'width', ((100 / cols) * width) + '%');
                this._setToComponent(cmp, 'top', ((100 / rows) * top) + '%');
                this._setToComponent(cmp, 'height', ((100 / rows) * height) + '%');
            },
            _setToComponent: function (cmp, pName, pValue) {
                cmp.set(pName, pValue);
                this._cache[cmp.id + pName] = pValue;
            },
            _prop: {
                rows: {},
                columns: {},
            }
        });
    });