/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 * *
 */
;// QUOKKA 2017
// By zibx on 5/29/17.

module.exports =
    QRequire('UI.UIComponent', function(
        UIComponent
    ) {
        'use strict';
        return UIComponent.extend('UI.Controls', 'Canvas', {
            createEl: function () {
                var self = this;
                this.el = document.createElement('canvas');
                this.ctx = this.el.getContext('2d');
                this.el.className = 'Q-UI-Canvas';

                this.el.addEventListener('click', function (event) {
                    self.fire('click', event);
                });

            },
            dot: function (obj) {
                this.ctx.fillRect(obj.x - 1, obj.y - 1, 2, 2);
            },
            _prop: {
                width: {
                    set: function (val) {
                        val += '';
                        if (val.indexOf('%') === -1 && val.indexOf('px') === -1)
                            this.el.width = val;
                    }
                },
                height: {
                    set: function (val) {
                        val += '';
                        if (val.indexOf('%') === -1 && val.indexOf('px') === -1)
                            this.el.height = val;
                    }
                }
            }
        });
    });