module.exports =
    QRequire('Core.QObject', 'Core.AbstractComponent', function(
        QObject,
        AbstractComponent
    ) {
        'use strict';


        /** @class */
        var Timer = QObject.extend('Core', 'Timer', {
            ctor: function () {
                this.set('counter', 0);
            },
            start: function () {
                if (this.interval) return;

                var self = this;
                var interval = this.get('interval');
                this.interval = setInterval(function () {
                    self.set('counter', self.get('counter') + 1);
                    self.fire('tick', self._data.counter);
                }, interval);
            },
            stop: function () {
                clearInterval(this.interval);
                this.interval = void(0);
            },
            _prop: {
                value: 'counter',
                counter: {},
                interval: {
                    set: function (val, e) {
                        if (this.get('enabled')) {
                            e.value(val);
                            this.start();
                        }
                    }
                },
                enabled: {
                    set: function (val, e) {
                        e.value(val);
                        if (val)
                            this.start();
                        else
                            this.stop();
                    }
                }
            }
        });

        return Timer;
    });