/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 * *
 */
;// QUOKKA 2017
// By zibx on 6/7/17.

module.exports = (function () {
    'use strict';
    var Http = require("http");
    var Fs = require("fs");
    var Path = require("path");

    var Server = function(cfg){
        var server = Http.createServer(function (req, res) {
            var reqURL = req.url,
                tokens = reqURL.split('?'),
                args = tokens[1];
            reqURL = tokens[0];
            var inPath = Path.join.apply(this, reqURL.split("/"));
            var rPath = inPath;
            console.log(inPath, rPath)
            if(rPath === '.'){
                res.end([
                    '<html>',
                    '<head><script src="source.js"></script></head>',
                    '<body><div id="viewport"></div>',
                    '<script>var main = QRequire.get(\'inline.main\').res; var m = new main();m.load()</script></body>',
                    '</html>'
                ].join('\n'))
            }else if(rPath === 'source.js'){
                return res.end(cfg.code);
            }else{
                Fs.stat(rPath, function (err, stat) {
                    if(err)
                        return res.end('no file');
                    if (stat.isFile()) {
                        var info = Path.parse(rPath);
                        Fs.readFile(rPath, function (err, fData) {
                            if (info.ext) {
                                var ext = info.ext.substr(1),
                                    headers = types[ext], i;
                                if (headers) {
                                    for (i in headers) {
                                        res.setHeader(i, headers[i]);
                                    }
                                }
                            }

                            //Content-Type: image/svg+xml
                            //Vary: Accept-Encoding
                            res.end(fData, 'binary');
                            return;
                        });
                    }
                });
            }
        });
        var port = 8000+((Math.random()*2000)|0);
        this.port = port;
        server.listen(port);
    };
    return Server;
})();