#!/usr/bin/env node
/**
 * Created by zibx on 5/30/17.
 */
var args = process.argv.slice(2);
var fileName = args[0];
var path = require('path');

var QRequire = global.QRequire = require(path.join(__dirname,'QRequire')),
    TypeTable = require(path.join(__dirname,'TypeTable')),
    uglify = require('uglify-js');


QRequire('quokka-script', 'quokka-core', 'Core.TypeTable', 'fs', function(qs, QCore, TypeTable, fs) {

    var cache = {};
    var getName = function (name, all) {
        var ns = all[name].namespace;
        if (ns)
            return ns + '.' + name;
        else
            return name;
    };
    var startDepsResolve = function (main, all, store) {
        store = store || {names: {}, list: []};
        console.log(main)
        var internal = all[main];
        if(internal) {
            var deps = all[main].require, depName, fullName;
            var x = 1;
            for (depName in deps) {
                if (!(depName in store.names)) {
                    startDepsResolve(depName, all, store);
                }
            }
        }
        fullName = main.indexOf('.')>-1? main : getName(main, all);


        //var cfg = TypeTable.search(fullName);
        /*if (cfg.length) {
            cfg = cfg[0];
            console.log(fullName, cfg.ctor.path)
        } else
             ;//throw new Error('No source for '+fullName)
        */
        var jsDeps = QRequire.deps(fullName);


        if(!(fullName in store.names)) {
            store.names[fullName] = jsDeps;
            store.list.push({name: fullName, deps: jsDeps, path: QRequire.path(fullName)});

        }
        jsDeps && jsDeps.forEach(function (dep) {
            if(!(dep in store.names)) {
                if(dep.indexOf('.')===-1){
                    store.names[dep] = true;
                    store.list.push({name: dep, path: QRequire.path(dep)});
                }else{
                    startDepsResolve(dep, all, store);

                }


            }
        });

        /*cache[fullName] = {
            require: deps ? Object.keys(deps).map(function (name) {
                    return getName(name, all);
                }) : [], code: 'code', cfg: cfg
        };*/
        return store;
    };
    var parsed = path.parse(fileName);
    var serverDir = path.join(__dirname, parsed.dir);

    qs({
        lib: [QCore.dir],
        typeTable: TypeTable,
        source: fs.readFileSync(fileName) + '',
        newWay: true
    }, function (result) {
        var mainObj = result.main;
        var paths = {},
            modulePaths = {};

        var deps = startDepsResolve(mainObj, result.world).list.filter(function (dep) {
            /*if(dep.name === 'observable-sequence')
                debugger;*/
            var d = QRequire.get(dep.name);
            if(d) {
                if (!(d instanceof QRequire.Waiter)) {
                    modulePaths[dep.name] = {path: d.filename, name: dep.name};
                    //d.paths && modulePaths.push(d.paths)
                }
            }
            return dep.path
        });
        deps.forEach(function(dep){
            paths[dep.path] = true;
        });



        var modules = [];
        Object.keys(modulePaths).forEach(function(name){
            modules.push(modulePaths[name]);
        });

        for(var i = 0; i < modules.length; i++){
            var module = modules[i];
            var mdl = require.cache[module.path];
            if(mdl.children)
                mdl.children.forEach(function(item){
                    var segments = item.filename.split(path.sep);
                    var index = segments.lastIndexOf('node_modules');
                    if (index === -1) return;
                    var name = segments[index + 1];


                    if(!(name in modulePaths)){
                        modulePaths[name] = {name: name, path: item.filename};
                        modules.push(modulePaths[name]);
                    }
                })
        }
        var letsConcat = [];
        modules.reverse().forEach(function(mdl){
            letsConcat.push('\n//'+ mdl.path +'\nQRequire.loaded('+JSON.stringify(mdl.name)+', QRequire.module(function(module){\n'+ fs.readFileSync(mdl.path) +'\n}) );\n');
        });
        Object.keys(paths).forEach(function(path){
            letsConcat.push('\n//'+ path +'\nQRequire.module(function(module){\n'+ fs.readFileSync(path) +'\n});\n');
        });

        letsConcat.unshift('QRequire = (function(QRequire){var require = QRequire.require');
        letsConcat.push('return QRequire;})((function(){var module = {}; '+
            fs.readFileSync(path.join(__dirname,'QRequire.js'))
            +'var require = module.exports.require;return module.exports;})())');

        letsConcat.push(result.js);

        var result = uglify.minify(letsConcat.join('\n'));
        var error = result.error;
        var code = result.code;

        var server = require('./server');
        var srv = new server({
            code: code,
            dir: serverDir
        });
        //fs.writeFileSync('../tmpConcat.js', code);
        //var x = require('../../tmpConcat');
        var open = require('open');
        open('http://localhost:'+srv.port);

        console.log(deps)
        //require
        //cache

    });
    console.log('arguments cmd', args);
    console.log('Building:', fileName);

});
//open('http://ya.ru')