module.exports =
    QRequire('z-observable', function(
        observable
    ) {
        function Node(name) {
            this.children = {};
            this.name = name || "";
            this.namespace = name || "";
            this.ctor = null;
        }

        Node.prototype = {
            findOne: function (path) {
                if (path.length <= 0)
                    return this;

                var targetChild = this.children[path[0]];
                if (!targetChild)
                    return void(0);
                return targetChild.findOne(path.splice(1));
            },
            findAll: function (name) {
                var ret = [];

                for (var key in this.children)
                    if (this.children.hasOwnProperty(key)) {
                        if (this.children[key].name == name)
                            ret.push(this.children[key]);
                        ret = ret.concat(this.children[key].findAll(name))
                    }

                return ret;
            }
        };
        var table = new Node();

        var TypeTable = {
            on: observable.prototype.on,
            fire: observable.prototype.fire,
            eventList: {},
            registerType: function (namespace, name, ctor) {
                var path = namespace.split('.');

                if (!ctor) {
                    ctor = name;
                    name = path.splice(-1)[0];
                }

                ctor.namespace = namespace;
                ctor.type = name;

                var currentNode = table;
                for (var i = 0; i < path.length; i++) {

                    if (!currentNode.children[path[i]]) {
                        currentNode.children[path[i]] = new Node(path[i]);
                    }

                    currentNode = currentNode.children[path[i]];
                }

                var typeNode = new Node(name);
                typeNode.ctor = ctor;
                typeNode.namespace = path.join('.');
                currentNode.children[name] = typeNode;

                (function () {

                    var pointer = this.Q = this.Q || {};
                    var targetNode =
                        path.reduce(function (pointer, name) {
                            pointer = pointer[name] = pointer[name] || {};
                            return pointer;
                        }, pointer);
                    targetNode[name] = ctor;
                }).call(null);
                this.fire('loaded', namespace, name, ctor);

                QRequire.loaded(ctor.namespace+'.'+ctor.type, ctor);

            },
            search: function (namespace, name) {
                namespace = namespace.split('.');
                if (!name)
                    name = namespace.splice(-1)[0];

                var ns = namespace.length > 0 ? table.findOne(namespace) : table;
                var results = ns.findAll(name);

                return results;
            },
            getType: function (namespace, name) {
                namespace = namespace.split('.');
                if (!name)
                    name = namespace.splice(-1)[0];
                var ns = namespace.length > 0 ? table.findOne(namespace) : table;

                if (!ns) {
                    throw new Error("Can't find " + name + " in " + namespace + '\n\r' + console.log(table));
                }

                var results = ns.findAll(name);

                //TODO add exception handling
                if (results.length > 0)

                    return results[0].ctor;
            }
        };

        TypeTable.registerType('Core', 'TypeTable', TypeTable);

        return TypeTable;
    });
