/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 * *
 */
;// QUOKKA 2017
// By zibx on 6/2/17.

module.exports = (function () {
    'use strict';
    var slice = [].slice;
    var waiting = {};
    var deps = {};
    var Waiter = function(args, fn){
        var argsPos = this.argsPos = {}, i, _i;
        this.args = args;
        this.deps = args.slice();
        this.count = args.length;
        this.fn = fn;

        for( i = 0, _i = args.length; i < _i; i++){
            argsPos[args[i]] = i;
        }
    };
    Waiter.prototype = {
        sub: function(){
            this.count--;
            this.may();
        },
        may: function(){
            var _self = this;
            if(!this.count) {
                var res = this.res = this.fn.apply(this, this.args);
                if(res) {
                    if (res instanceof Array) {
                        res.forEach(function(res){
                            if(!res)
                                debugger;
                            deps[res.namespace + '.' + res.type] = _self;
                        });

                    }

                    if (res.namespace && res.type) {
                        deps[res.namespace + '.' + res.type] = this;
                    }
                }
                delete this.args;
                delete this.argsPos;
            }
        },
        set: function(name, val){
            this.args[this.argsPos[name]] = val;
            this.sub();
        }
    };
    var QRequire = function(){
        var args = slice.call(arguments),
            fn = args.pop(),

            waiter = new Waiter(args, fn),
            i, _i, arg;

        for( i = 0, _i = args.length; i < _i; i++){
            arg = args[i];
            if(!(arg in waiting)){
                waiting[arg] = [];
            }
            if(!Array.isArray(waiting[arg]))
                waiter.set(arg, waiting[arg]);
            else {
                waiting[arg].push(waiter);
                if(arg.indexOf('.')===-1){
                    QRequire.loaded(arg, require(arg));
                }
            }
        }

        //waiter.may();
    };
    QRequire.loaded = function(name, obj){
        console.log(name, typeof obj)
        var waiter = waiting[name];
        if(waiter instanceof Array){
            for( var i = 0, _i = waiter.length; i < _i; i++ ){
                waiter[i].set(name, obj);
            }
        }
        waiting[name] = obj;
    };

    QRequire.deps = function(name){
        return (deps[name] || {}).deps;
    };
    return QRequire;
})();