// Класс игрока
class Player extends GameObject {
	init(){
		this.extendSprite();
		this.position[1]++;
		this.collisionOffset = [5,8,5,9];
		this.xSpeed = 24
		this.jumpSpeed = 32
		this.onGround = true;
		this.yAcceleration = 0;
		this.G = 0.98;

		//this.DEBUG = true;
		this.loadAnimation('stay', {
			path: 'sprites/playerStay.png',
			size: [32, 64],
			frames: 2,
			duration: 1
		});
		this.loadAnimation('walk', {
			path: 'sprites/playerWalk.png',
			size: [32, 64],
			frames: 4,
			duration: 1
		});
		this.loadAnimation('jump', {
			path: 'sprites/playerJump.png',
			size: [32, 64],
			frames: 3,
			manual: true,
			duration: 1
		});
	}
	step(dt, tfs){

		var futureX = this.position[0];
		if(Keys.Right){
			futureX += dt*this.xSpeed*(Math.sin(tfs*4*3.14)/6+1);
			this.tile.f = 0;
			this.setAnimation('walk');
		}
		if(Keys.Left){
			futureX -= dt*this.xSpeed*(Math.sin(tfs*4*3.14)/6+1);
			this.tile.f = 1;
			this.setAnimation('walk');
		}

		if(!Keys.Left && !Keys.Right){
			this.setAnimation('stay');
		}

		if(!this.wouldCollide([futureX, this.position[1]], ['Level', 'Patches'])){
			this.position[0] = futureX;
		}

		if(Keys.Up){
			if(this.onGround){
				zzfx(...[1.99,,782,,.22,0,,1.77,,-24,,,,,,,.23]);
				//zzfx(...[1.11,,466,.08,,.12,2,1.56,-7.1,,-357,.05,-0.01,,,,.01,.73]); // Random 216 - Mutation 2
				this.yAcceleration = this.jumpSpeed;
				this.onGround = false;
			}
		}

		this.yAcceleration -= this.G;
		while(true){
			var futureY = this.position[ 1 ] - this.yAcceleration * dt;
			if( !this.wouldCollide( [ this.position[ 0 ], futureY ], [ 'Level', 'Patches' ] ) ){
				this.position[ 1 ] = futureY;
				this.onGround = false;
				var jumpFrame = 1;
				if( this.yAcceleration > 10 ){
					jumpFrame = 0;
				}else if( this.yAcceleration < -8 ){
					jumpFrame = 2;
				}

				this.setAnimation( 'jump', jumpFrame );
				break;
			}else{
				this.yAcceleration *= 0.9;
				if(Math.abs(this.yAcceleration)<0.2){
					this.onGround = true;
					break;
				}
			}
		}
		if(this.onGround){
			this.yAcceleration = 0;

		}
		if(Keys.Down){
			this.position[1]++;
		}

		this.updateAnimation(dt);
		//this
		//this.tile.srcRect[0] = 32*((tfs*4%4)|0);

		//this.position[1]+=Math.sin(dt)
		Camera.position[0] = this.position[0]+this.width/2;

		Camera.position[1] = this.position[1]-this.height/3;
	}
	onFrameChange(name, frame){
		if(name === 'walk'){
			if(frame % 2 === 1){
				zzfx( ...[ 1.04, , 213, .01, , .02, 1, 2.79, , , , , , .1, , , , .77, .01 ] ); // Blip 155
			}
		}else if(name === 'jump'){

		}

	}
	draw(){
		this.render();
		//this.debug();
	}
	die(){
		zzfx(...[,,435,.01,.01,.09,2,1.1,-3.2,,,,,,,,,.87,.1]);
	}
}