import Consts from "./Consts"

const Strings = {
  ADMIN_MENU: [
    {
      id: 0,
      name: "Список сотрудников",
      link: Consts.ROUTES.ADMIN.EMPLOYEES,
    },
    {
      id: 1,
      name: "Управление контентом",
      link: Consts.ROUTES.ADMIN.CONTENTS,
    },
    {
      id: 2,
      name: "Управление тестированием",
      link: Consts.ROUTES.ADMIN.TESTING,
    },
    {
      id: 3,
      name: "Статистика",
      link: Consts.ROUTES.ADMIN.STATISTICS,
    },
  ],
  AUTH: {
    AUTH_PROBLEM: "Проблемы с авторизацией?",
    AUTH_PROBLEM_TEXT: "Текст про то, куда писать и звонить",
    AUTH_PROBLEM_PHONE: "8 800 000 00 00",
    TO_LOGIN: "Вернуться к авторизации",
    EXIT: "Выйти",
    ROLES: {
      ROLE_ADMIN: {
        id: 1,
        str: "Как администратор",
        props: { arrow: true, theme: "submit", type: "button" },
      },
      ROLE_EMPLOYEE: {
        id: 2,
        str: "Как пользователь",
        props: { arrow: "next", theme: "default", type: "button" },
      },
    },
    CHOOSE_ROLE_TITLE: "Вы хотите войти как администратор или как пользователь?",
    FORM_PHONE_LABEL: "Введите номер телефона, чтобы продолжить.",
    FORM_LOGIN_LABEL: "Введите код из СМС",
    WELLCOME: "Добро пожаловать в\u00A0\развивающую платформу Вкусвилл!",
  },
  BUTTONS: {
    FARTHER: "Далее",
  },
  ERRORS: {
    API: {
      [Consts.ERRORS.API.NO_ENDPOINT]: "Такого endpoint не существует",
    },
    FIELDS: {
      VALUE_MISSING: "Поле не заполнено",
      MIN_VALUE: "Поле заполнено некорректно",
    },
  },
  ACCOUNT: {
    MAIN: {
      NEW_CARDS: "Новые карточки для вашей должности:",
    },
    GREETING: {
      HEADER: "Добро пожаловать!",
      TEXT1: "Мы очень рады видеть вас во внутренней базе знаний ВкусВилла!\n",
      TEXT2:
        "Здесь собрана информация по всему ассортименту продуктов и правилам взаимодействия с покупателями.\n" +
        "Для закрепления и проверки знаний можно всегда пройти интерактивное тестирование!\n" +
        "\n" +
        "**Вы будете одним из первых сотрудников получивших доступ к продукту находящемуся в разработке. Обязательно сообщайте о всех выявленных проблемах — мы постараемся как можно быстрее всё исправить.**",
    },
    PERSONAL_AREA: {
      FINAL_TESTING: "Итоговое тестирование",
      PASSED: "Пройдено",
      YOU_HAVE_NOT_PASSED: "Вы еще не проходили итоговое тестирование",
      PERSONAL_AREA: "Личный кабинет",
      TODAY_YOU_CAN: "Сегодня вы можете",
      NEW_CARDS_FOR_YOU_POST: "Новые карточки для вашей должности",
      YOU_LOOKED_AT_ALL_THE_NEW_CARDS: "Вы просмотрели все новые карточки этого месяца.",
      KEEP_IT_UP: "Так держать!",
      BUTTONS: {
        FINAL_TEST: "Пройти итоговое тестирование",
        TRIAL_TEST: "Пройти пробное тестирование",
        VIEW_KNOWLEDGE_BASE: "Посмотреть базу знаний",
      },
    },
    TESTING: {
      WELCOME: {
        HEADER: "Добро пожаловать\nв\u00A0итоговое\nтестирование!",
        TEXT1:
          "Ассортимент наших магазинов постоянно расширяется и на главном экране появляются карточки с новыми товарами.\n\n"+
          "Тестирование — это проверка вашей подготовки к работе с покупателями.\n" +
          "Если не уверены в своих знаниях — потренеруйтесь на пробном тестировании.\n",
        TEXT2: "Тестирование проходит в период: ",
      },
      NOT_ACTIVATED: {
        ATTENTION: "Внимание!",
        HEADER: "Тестирование не\u00A0активировано",
        TEXT1:
          "Текст про то, что тестирование еще не активировано. СТА -\n" +
          "потренироваться на пробном тестировании.\n" +
          "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi\n" +
          "lacinia augue quam, in dapibus nulla ullamcorper nec. Mauris\n" +
          "ac magna est.",
      },
      CONFIRMATION: {
        HEADER: "Тестирование невозможно прервать",
        TEXT: "Это последнее предупреждение. Вы уверены, что\nготовы начать?",
      },
      RESULT: {
        CONGRATULATION: "Поздравляем!",
        RESULT: "Ваш результат:",
        CORRECT_COUNT: "Вы верно ответили на",
        HEADER: "Вы завершили тестирование!",
        HEADER_TOP: "Вы вошли в ТОП лучших ответов!",
        HEADER_BAD: "Тестирование завершено",
        TEXT1:
          "ТОП лучших ответов означает, что в следующем\n" +
          "тестировании вам нужно будет ответить на меньшее\n" +
          "количество вопросов.Отличная работа! Мы гордимся\n" +
          "вами!",
        TEXT2:
          "К сожалению, это очень низкий результат.\n" +
          "Мы верим, что вы можете лучше! При подготовке к\n" +
          "следующему тестированию, попробуйте\n" +
          "потренироваться на пробном тесте или почитать\n" +
          "нашу базу знаний.",
        FINAL: "Спасибо за участие в тестировании!\nУвидимся через месяц!",
        INTERRUPT_HEADER: "Тестирование было прервано",
        INTERRUPT_TEXT1: "Вам придется начать его заново.",
        INTERRUPT_TEXT2:
          "Это могло произойти из-за проблем в соединении с\n" +
          'интернетом либо из-за нажатия кнопки "назад".\n' +
          "Пожалуйста, убедитесь, что Вы находитесь в зоне хорошего\n" +
          "приема и начните тестирование снова.",
      },
      ANSWERS_TYPE: {
        RADIO: "Возможен единственный выбор",
        CHECKBOX: "Возможно несколько вариантов",
      },
    },
  },
  LOGIN: {
    SMS: {
      PLACEHOLDER: "000000",
    },
    LOGIN: "Ваш телефон",
  },
  KNOWLEDGE: {
    CATEGORY: {
      TITLE: "База знаний",
      SUBTITLE: "Категории",
    },
    CARDS: {
      CARDS_IN_CATEGORY: "Карточек в категории",
      VIEWED: "Просмотрено",
    },
  },
  BUTTON: {
    CONTINUE: "Продолжить",
    PRACTICE_FIRST: "Сначала потренироваться",
    START_TESTING: "Начать тестирование",
    READY_GO: "Я готов! Начать",
    SHOW_MY_ANSWERS: "Посмотреть мои ответы",
    COMPLETE_TESTING: "Завершить тестирование",
    DONE: "Готово",
    START_OVER: "Начать заново",
    SHOW_CARD: "Посмотреть карточку с информацией",
  },
}

export default Strings
