import './quizProgress.scss';
import ForwardArr from '/svg/forward.svg';

const QuizProgress = D.declare('view.cmp.QuizProgress', () => {
    return <div class="quiz-progress">
        <button class="quiz-progress__control quiz-progress__control--back quiz-progress__control--disabled" type="button" aria-label="Перейти к предыдущему вопросу">
            <ForwardArr width="9" height="16"/>
        </button>
        <ul className="quiz-progress__list">
            {(()=>{
                var out = [];
                var el;
                for (var i = 0; i < 30; i++) {
                    var arr = ['quiz-progress__item'];
                    if (i < 5) {
                        arr.push('quiz-progress__item--disabled');
                    }
                    if (i === 5) {
                        arr.push('quiz-progress__item--true quiz-progress__item--current');
                    }
                    if (i === 7) {
                        arr.push('quiz-progress__item--false quiz-progress__item--current');
                    }
                    if (i > 7 && i < 11) {
                        arr.push('quiz-progress__item--true');
                    }
                    if (i > 11 && i < 19) {
                        arr.push('quiz-progress__item--false');
                    }
                    el = <li class={arr.join(' ')}>{i+1}</li>;

                    out.push(el);
                }
                return out;
            })()}
        </ul>
        <button class="quiz-progress__control quiz-progress__control--forward quiz-progress__control--disabled" type="button" aria-label="Перейти к следующему вопросу">
            <ForwardArr width="9" height="16"/>
        </button>
    </div>
})

export default QuizProgress;
export {QuizProgress};
