import './accountPage.scss';
import AccountBlock from '../../block/account/Account.jsx';
import {AsyncAuthAjax} from "../../../controller/Ajax";
import {API} from "../../../dict/Consts";
import Card from "../../cmp/card/Card";
import CardSlider from "../../cmp/cardSlider/CardSlider";

const Account = D.declare('view.page.Account', () => {
    let Slider = new CardSlider( {

        name: "newCardsSlider",

        itemClick: ( item, action ) => {
          action.execute( item );
        },


        items: _ => store.sub(
          [
            'loaded.cards',
            'navigation.current',
            tmpStore.bind( 'loaded' ),
            tmpStore.bind( 'newCardsLoaded' ),
          ],
          function( loadedCards, page, loaded, newCardsLoaded ){
            console.log( loadedCards, page, loaded, newCardsLoaded )
            if( newCardsLoaded !== loadedCards ){
              if( loadedCards && page === 'Account' && loaded ){
                _( cards
                  .getArray()
                  .filter( card => card.seen === false )
                  .sort( ( a, b ) => a.id - b.id )
                );

                tmpStore.set( 'newCardsLoaded', loadedCards )
              }
            }
          }
        )
      } );

    const dom = <div class="account-page">
        <h1 class="readers-only">Страница личного кабинета сотрудника</h1>
        <div class="account-page__wrapper">
            <div class="account-page__menu">
                <div class="account-page__menu-inner">
                    <AccountBlock />
                </div>
            </div>
            <div class="account-page__content">
                <div class="account-page__content-inner">
                    <div class="account-page__cards">
                        <h2 class="account-page__title">Новые карточки для вашей должности:</h2>
                      {Slider}

                    </div>
                </div>
            </div>
        </div>
    </div>;

  tmpStore.valEqualOnly('afterNavigation.to', 'Account')(function() {
    Slider.restore();
  });
  tmpStore.valEqualOnly('beforeNavigation.from', 'Account')(function() {
    Slider.save();
  });

  return dom;
});

export default Account;
export {Account};
